/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.common.util.FutureUtils;
import io.skylite.core.index.shard.IndexShardRelocatedException;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.shard.IndexShard;

public final class RunUnderPrimaryPermit {
    public static void run(CancellableThreads.Interruptible runnable, String reason, IndexShard primary, CancellableThreads cancellableThreads, Logger logger) {
        cancellableThreads.execute(() -> {
            final CompletableFuture permit = new CompletableFuture();
            ActionListener<Releasable> onAcquired = new ActionListener<Releasable>(){

                public void onResponse(Releasable releasable) {
                    if (!permit.complete(releasable)) {
                        releasable.close();
                    }
                }

                public void onFailure(Exception e) {
                    permit.completeExceptionally(e);
                }
            };
            primary.acquirePrimaryOperationPermit(onAcquired, "same", reason);
            try (Releasable ignored = (Releasable)FutureUtils.get(permit);){
                if (primary.isRelocatedPrimary()) {
                    throw new IndexShardRelocatedException(primary.shardId());
                }
                runnable.run();
            }
            finally {
                permit.whenComplete((r, e) -> {
                    if (r != null) {
                        r.close();
                    }
                    if (e != null) {
                        logger.trace("suppressing exception on completion (it was already bubbled up or the operation was aborted)", e);
                    }
                });
            }
        });
    }
}

