/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.skylite.common.ValidationException;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.Index;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class ShardLimitValidator {
    public static final String SETTING_MAX_SHARDS_PER_CLUSTER_KEY = "cluster.routing.allocation.total_shards_limit";
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting((String)"cluster.max_shards_per_node", (int)1000, (int)1, (Setting.Validator)new MaxShardPerNodeLimitValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER = Setting.intSetting((String)"cluster.routing.allocation.total_shards_limit", (int)-1, (int)-1, (Setting.Validator)new MaxShardPerClusterLimitValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> SETTING_CLUSTER_IGNORE_DOT_INDEXES = Setting.boolSetting((String)"cluster.ignore_dot_indexes", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    protected final AtomicInteger shardLimitPerNode = new AtomicInteger();
    protected final AtomicInteger shardLimitPerCluster = new AtomicInteger();
    private final SystemIndices systemIndices;
    private volatile boolean ignoreDotIndexes;

    public ShardLimitValidator(Settings settings, ClusterService clusterService, SystemIndices systemIndices) {
        this.shardLimitPerNode.set((Integer)SETTING_CLUSTER_MAX_SHARDS_PER_NODE.get(settings));
        this.shardLimitPerCluster.set((Integer)SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER.get(settings));
        this.ignoreDotIndexes = (Boolean)SETTING_CLUSTER_IGNORE_DOT_INDEXES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_NODE, this::setShardLimitPerNode);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER, this::setShardLimitPerCluster);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_IGNORE_DOT_INDEXES, this::setIgnoreDotIndexes);
        this.systemIndices = systemIndices;
    }

    private void setShardLimitPerNode(int newValue) {
        this.shardLimitPerNode.set(newValue);
    }

    private void setShardLimitPerCluster(int newValue) {
        this.shardLimitPerCluster.set(newValue);
    }

    public int getShardLimitPerNode() {
        return this.shardLimitPerNode.get();
    }

    public int getShardLimitPerCluster() {
        return this.shardLimitPerCluster.get();
    }

    private void setIgnoreDotIndexes(boolean newValue) {
        this.ignoreDotIndexes = newValue;
    }

    public void validateShardLimit(String indexName, Settings settings, ClusterState state) {
        int numberOfReplicas;
        if (this.shouldIndexBeIgnored(indexName)) {
            return;
        }
        int numberOfShards = (Integer)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = ((Integer)IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings)).intValue()));
        Optional<String> shardLimit = this.checkShardLimit(shardsToCreate, state);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    public void validateShardLimit(ClusterState currentState, Index[] indicesToOpen) {
        int shardsToOpen = Arrays.stream(indicesToOpen).filter(index -> !this.shouldIndexBeIgnored(index.getName())).filter(index -> currentState.metadata().index(index).getState().equals((Object)IndexMetadata.State.CLOSE)).mapToInt(index -> ShardLimitValidator.getTotalShardCount(currentState, index)).sum();
        Optional<String> error = this.checkShardLimit(shardsToOpen, currentState);
        if (error.isPresent()) {
            ValidationException ex = new ValidationException();
            ex.addValidationError(error.get());
            throw ex;
        }
    }

    private static int getTotalShardCount(ClusterState state, Index index) {
        IndexMetadata indexMetadata = state.metadata().index(index);
        return indexMetadata.getNumberOfShards() * (1 + indexMetadata.getNumberOfReplicas());
    }

    private boolean shouldIndexBeIgnored(String indexName) {
        if (this.ignoreDotIndexes) {
            return this.validateDotIndex(indexName) && !this.isDataStreamIndex(indexName);
        }
        return this.systemIndices.validateSystemIndex(indexName);
    }

    private boolean validateDotIndex(String indexName) {
        return indexName.charAt(0) == '.';
    }

    private boolean isDataStreamIndex(String indexName) {
        return indexName.startsWith(".ds-");
    }

    public Optional<String> checkShardLimit(int newShards, ClusterState state) {
        return ShardLimitValidator.checkShardLimit(newShards, state, this.getShardLimitPerNode(), this.getShardLimitPerCluster());
    }

    static Optional<String> checkShardLimit(int newShards, ClusterState state, int maxShardsPerNodeSetting, int maxShardsPerClusterSetting) {
        int nodeCount = state.getNodes().getDataNodes().size();
        if (nodeCount == 0 || newShards < 0) {
            return Optional.empty();
        }
        int maxShardsInCluster = maxShardsPerClusterSetting;
        maxShardsInCluster = maxShardsInCluster == -1 ? maxShardsPerNodeSetting * nodeCount : Math.min(maxShardsInCluster, maxShardsPerNodeSetting * nodeCount);
        int currentOpenShards = state.getMetadata().getTotalOpenIndexShards();
        if (currentOpenShards + newShards > maxShardsInCluster) {
            String errorMessage = "this action would add [" + newShards + "] total shards, but this cluster currently has [" + currentOpenShards + "]/[" + maxShardsInCluster + "] maximum shards open";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    private static void doValidate(int maxShardPerCluster, int maxShardPerNode) {
        if (maxShardPerCluster != -1 && maxShardPerCluster < maxShardPerNode) {
            throw new IllegalArgumentException("MaxShardPerCluster " + maxShardPerCluster + " should be greater than or equal to MaxShardPerNode " + maxShardPerNode);
        }
    }

    static final class MaxShardPerNodeLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerNodeLimitValidator() {
        }

        public void validate(Integer value) {
        }

        public void validate(Integer maxShardPerNode, Map<Setting<?>, Object> settings) {
            int maxShardPerCluster = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            return settings.iterator();
        }
    }

    static final class MaxShardPerClusterLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerClusterLimitValidator() {
        }

        public void validate(Integer value) {
        }

        public void validate(Integer maxShardPerCluster, Map<Setting<?>, Object> settings) {
            int maxShardPerNode = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            return settings.iterator();
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SETTING_CLUSTER_MAX_SHARDS_PER_NODE, SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER, SETTING_CLUSTER_IGNORE_DOT_INDEXES);
        }
    }
}

