/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import io.skylite.SkyliteException;
import io.skylite.SkyliteParseException;
import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.OriginSettingClient;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.health.ClusterIndexHealth;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class SystemIndexManager
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexManager.class);
    private final SystemIndices systemIndices;
    private final Client client;
    private final AtomicBoolean isUpgradeInProgress;

    public SystemIndexManager(SystemIndices systemIndices, Client client) {
        this.systemIndices = systemIndices;
        this.client = client;
        this.isUpgradeInProgress = new AtomicBoolean(false);
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(ClusterBlocks.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("system indices manager waiting until state has been recovered");
            return;
        }
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (this.isUpgradeInProgress.compareAndSet(false, true)) {
            List<SystemIndexDescriptor> descriptors = this.getEligibleDescriptors(state.getMetadata()).stream().filter(descriptor -> this.getUpgradeStatus(state, (SystemIndexDescriptor)descriptor) == UpgradeStatus.NEEDS_MAPPINGS_UPDATE).collect(Collectors.toList());
            if (!descriptors.isEmpty()) {
                GroupedActionListener listener = new GroupedActionListener(ActionListenerHelper.wrap(() -> this.isUpgradeInProgress.set(false)), descriptors.size());
                descriptors.forEach(arg_0 -> this.lambda$clusterChanged$2((ActionListener)listener, arg_0));
            } else {
                this.isUpgradeInProgress.set(false);
            }
        }
    }

    List<SystemIndexDescriptor> getEligibleDescriptors(Metadata metadata) {
        return this.systemIndices.getSystemIndexDescriptors().stream().filter(SystemIndexDescriptor::isAutomaticallyManaged).filter(d -> metadata.hasConcreteIndex(d.getPrimaryIndex())).collect(Collectors.toList());
    }

    UpgradeStatus getUpgradeStatus(ClusterState clusterState, SystemIndexDescriptor descriptor) {
        State indexState = this.calculateIndexState(clusterState, descriptor);
        String indexDescription = "Index [" + descriptor.getPrimaryIndex() + "] (alias [" + descriptor.getAliasName() + "])";
        if (indexState.indexState == IndexMetadata.State.CLOSE) {
            logger.debug("Index {} is closed. This is likely to prevent some features from functioning correctly", (Object)indexDescription);
            return UpgradeStatus.CLOSED;
        }
        if (indexState.indexHealth == ClusterHealthStatus.RED) {
            logger.debug("Index {} health status is RED, any pending mapping upgrades will wait until this changes", (Object)indexDescription);
            return UpgradeStatus.UNHEALTHY;
        }
        if (!indexState.isIndexUpToDate) {
            logger.debug("Index {} is not on the current version. Features relying on the index will not be available until the index is upgraded", (Object)indexDescription);
            return UpgradeStatus.NEEDS_UPGRADE;
        }
        if (indexState.mappingUpToDate) {
            logger.trace("Index {} is up-to-date, no action required", (Object)indexDescription);
            return UpgradeStatus.UP_TO_DATE;
        }
        logger.info("Index {} mappings are not up-to-date and will be updated", (Object)indexDescription);
        return UpgradeStatus.NEEDS_MAPPINGS_UPDATE;
    }

    private void upgradeIndexMetadata(SystemIndexDescriptor descriptor, final ActionListener<AcknowledgedResponse> listener) {
        final String indexName = descriptor.getPrimaryIndex();
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(descriptor.getMappings(), MediaTypeRegistry.JSON);
        OriginSettingClient originSettingClient = new OriginSettingClient(this.client, descriptor.getOrigin());
        originSettingClient.admin().indices().putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(this){

            public void onResponse(AcknowledgedResponse response) {
                if (!response.isAcknowledged()) {
                    String message = "Put mapping request for [" + indexName + "] was not acknowledged";
                    logger.error(message);
                    listener.onFailure((Exception)new SkyliteException(message, new Object[0]));
                } else {
                    listener.onResponse((Object)response);
                }
            }

            public void onFailure(Exception e) {
                logger.error("Put mapping request for [" + indexName + "] failed", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    State calculateIndexState(ClusterState state, SystemIndexDescriptor descriptor) {
        ClusterHealthStatus indexHealth;
        IndexMetadata indexMetadata = state.metadata().index(descriptor.getPrimaryIndex());
        assert (indexMetadata != null);
        boolean isIndexUpToDate = ((Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings())).intValue() == descriptor.getIndexFormat();
        boolean isMappingIsUpToDate = this.checkIndexMappingUpToDate(descriptor, indexMetadata);
        String concreteIndexName = indexMetadata.getIndex().getName();
        IndexMetadata.State indexState = indexMetadata.getState();
        if (indexState == IndexMetadata.State.CLOSE) {
            indexHealth = null;
            logger.warn("Index [{}] (alias [{}]) is closed. This is likely to prevent some features from functioning correctly", (Object)concreteIndexName, (Object)descriptor.getAliasName());
        } else {
            IndexRoutingTable routingTable = state.getRoutingTable().index(indexMetadata.getIndex());
            indexHealth = new ClusterIndexHealth(indexMetadata, routingTable).getStatus();
        }
        return new State(indexState, indexHealth, isIndexUpToDate, isMappingIsUpToDate);
    }

    private boolean checkIndexMappingUpToDate(SystemIndexDescriptor descriptor, IndexMetadata indexMetadata) {
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata == null) {
            return false;
        }
        return Version.CURRENT.equals((Object)this.readMappingVersion(descriptor, mappingMetadata));
    }

    private Version readMappingVersion(SystemIndexDescriptor descriptor, MappingMetadata mappingMetadata) {
        String indexName = descriptor.getPrimaryIndex();
        try {
            Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.warn("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetadata.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read version string in index " + indexName);
            }
            String versionString = (String)meta.get(descriptor.getVersionMetaKey());
            if (versionString == null) {
                logger.warn("No value found in mappings for [_meta.{}]", (Object)descriptor.getVersionMetaKey());
            }
            return Version.fromString((String)versionString);
        }
        catch (SkyliteParseException e) {
            logger.error((Message)new ParameterizedMessage("Cannot parse the mapping for index [{}]", (Object)indexName), (Throwable)e);
            throw new SkyliteException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    private /* synthetic */ void lambda$clusterChanged$2(ActionListener listener, SystemIndexDescriptor descriptor) {
        this.upgradeIndexMetadata(descriptor, (ActionListener<AcknowledgedResponse>)listener);
    }

    static class State {
        final IndexMetadata.State indexState;
        final ClusterHealthStatus indexHealth;
        final boolean isIndexUpToDate;
        final boolean mappingUpToDate;

        State(IndexMetadata.State indexState, ClusterHealthStatus indexHealth, boolean isIndexUpToDate, boolean mappingUpToDate) {
            this.indexState = indexState;
            this.indexHealth = indexHealth;
            this.isIndexUpToDate = isIndexUpToDate;
            this.mappingUpToDate = mappingUpToDate;
        }
    }

    static enum UpgradeStatus {
        CLOSED,
        UNHEALTHY,
        NEEDS_UPGRADE,
        UP_TO_DATE,
        NEEDS_MAPPINGS_UPDATE;

    }
}

