/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.action.support.PlainActionFuture;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.util.FutureUtils;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.PeerRecoveryNotFound;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoverySourceHandler;
import org.opensearch.indices.recovery.RecoverySourceHandlerFactory;
import org.opensearch.indices.recovery.ReestablishRecoveryRequest;
import org.opensearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.opensearch.indices.recovery.StartRecoveryRequest;

public class PeerRecoverySourceService
extends AbstractLifecycleComponent
implements IndexEventListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PeerRecoverySourceService.class);
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    @Inject
    public PeerRecoverySourceService(TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings) {
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", "generic", StartRecoveryRequest::new, (TransportRequestHandler)new StartRecoveryTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/reestablish_recovery", "generic", ReestablishRecoveryRequest::new, (TransportRequestHandler)new ReestablishRecoveryTransportRequestHandler());
    }

    protected void doStart() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.isDataNode((Settings)clusterService.getSettings())) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    protected void doStop() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.isDataNode((Settings)clusterService.getSettings())) {
            this.ongoingRecoveries.awaitEmpty();
            this.indicesService.clusterService().removeListener((ClusterStateListener)this);
        }
    }

    protected void doClose() {
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel((IndexShard)indexShard, "shard is closed");
        }
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.ongoingRecoveries.cancelOnNodeLeft(removedNode);
            }
        }
    }

    private void recover(StartRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        ShardRouting routingEntry = shard.routingEntry();
        if (!routingEntry.primary() || !routingEntry.active()) {
            throw new DelayRecoveryException("source shard [" + String.valueOf(routingEntry) + "] is not an active primary");
        }
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            logger.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + String.valueOf(request.targetNode()) + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        logger.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        handler.recoverToTarget((ActionListener<RecoveryResponse>)ActionListenerHelper.runAfter(listener, () -> this.ongoingRecoveries.remove(shard, handler)));
    }

    private void reestablish(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        logger.trace("[{}][{}] reestablishing recovery {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.recoveryId());
        this.ongoingRecoveries.reestablishRecovery(request, shard, listener);
    }

    final int numberOfOngoingRecoveries() {
        return this.ongoingRecoveries.ongoingRecoveries.size();
    }

    final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();
        private final Map<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>> nodeToHandlers = new HashMap<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>>();
        @Nullable
        private List<ActionListener<Void>> emptyListeners;

        OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> handlers = shardContext.addNewRecovery(request, shard);
            RemoteRecoveryTargetHandler recoveryTargetHandler = (RemoteRecoveryTargetHandler)handlers.v2();
            this.nodeToHandlers.computeIfAbsent(recoveryTargetHandler.targetNode(), k -> new HashSet()).add(recoveryTargetHandler);
            shard.recoveryStats().incCurrentAsSource();
            return (RecoverySourceHandler)handlers.v1();
        }

        synchronized void cancelOnNodeLeft(DiscoveryNode node) {
            Collection<RemoteRecoveryTargetHandler> handlers = this.nodeToHandlers.get(node);
            if (handlers != null) {
                for (RemoteRecoveryTargetHandler handler : handlers) {
                    handler.cancel();
                }
            }
        }

        synchronized void reestablishRecovery(ReestablishRecoveryRequest request, IndexShard shard, ActionListener<RecoveryResponse> listener) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.get((Object)shard);
            if (shardContext == null) {
                throw new PeerRecoveryNotFound(request.recoveryId(), request.shardId(), request.targetAllocationId());
            }
            shardContext.reestablishRecovery(request, listener);
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get((Object)shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + String.valueOf((Object)shard) + "]";
            RemoteRecoveryTargetHandler removed = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (removed != null) : "Handler was not registered [" + String.valueOf(handler) + "]";
            if (removed != null) {
                shard.recoveryStats().decCurrentAsSource();
                removed.cancel();
                assert (((Collection)this.nodeToHandlers.getOrDefault(removed.targetNode(), Collections.emptySet())).contains(removed)) : "Remote recovery was not properly tracked [" + String.valueOf(removed) + "]";
                this.nodeToHandlers.computeIfPresent(removed.targetNode(), (k, handlersForNode) -> {
                    handlersForNode.remove(removed);
                    if (handlersForNode.isEmpty()) {
                        return null;
                    }
                    return handlersForNode;
                });
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove((Object)shard);
            }
            if (this.ongoingRecoveries.isEmpty() && this.emptyListeners != null) {
                List<ActionListener<Void>> onEmptyListeners = this.emptyListeners;
                this.emptyListeners = null;
                ActionListenerHelper.onResponse(onEmptyListeners, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get((Object)shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers.keySet()) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEmpty() {
            PlainActionFuture future;
            assert (PeerRecoverySourceService.this.lifecycle.stoppedOrClosed());
            OngoingRecoveries ongoingRecoveries = this;
            synchronized (ongoingRecoveries) {
                if (this.ongoingRecoveries.isEmpty()) {
                    return;
                }
                future = new PlainActionFuture();
                if (this.emptyListeners == null) {
                    this.emptyListeners = new ArrayList<ActionListener<Void>>();
                }
                this.emptyListeners.add((ActionListener<Void>)future);
            }
            FutureUtils.get((Future)future);
        }

        private final class ShardRecoveryContext {
            final Map<RecoverySourceHandler, RemoteRecoveryTargetHandler> recoveryHandlers = new HashMap<RecoverySourceHandler, RemoteRecoveryTargetHandler>();

            private ShardRecoveryContext() {
            }

            synchronized Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (!existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    throw new DelayRecoveryException("recovery with same target already registered, waiting for previous recovery attempt to be cancelled or completed");
                }
                Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> handlers = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.put((RecoverySourceHandler)handlers.v1(), (RemoteRecoveryTargetHandler)handlers.v2());
                return handlers;
            }

            synchronized void reestablishRecovery(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
                RecoverySourceHandler handler = null;
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (existingHandler.getRequest().recoveryId() != request.recoveryId() || !existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    handler = existingHandler;
                    break;
                }
                if (handler == null) {
                    throw new ResourceNotFoundException("Cannot reestablish recovery, recovery id [" + request.recoveryId() + "] not found.", new Object[0]);
                }
                handler.addListener(listener);
            }

            private Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime(throttleTime.longValue()), shard.isRemoteTranslogEnabled() || request.targetNode().isRemoteStoreNode());
                RecoverySourceHandler handler = RecoverySourceHandlerFactory.create(shard, recoveryTarget, request, PeerRecoverySourceService.this.recoverySettings);
                return Tuple.tuple((Object)handler, (Object)recoveryTarget);
            }
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
        public static final String REESTABLISH_RECOVERY = "internal:index/shard/recovery/reestablish_recovery";
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        public void messageReceived(StartRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            PeerRecoverySourceService.this.recover(request, (ActionListener<RecoveryResponse>)new ChannelActionListener(channel, "internal:index/shard/recovery/start_recovery", (TransportRequest)request));
        }
    }

    class ReestablishRecoveryTransportRequestHandler
    implements TransportRequestHandler<ReestablishRecoveryRequest> {
        ReestablishRecoveryTransportRequestHandler() {
        }

        public void messageReceived(ReestablishRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            PeerRecoverySourceService.this.reestablish(request, (ActionListener<RecoveryResponse>)new ChannelActionListener(channel, "internal:index/shard/recovery/reestablish_recovery", (TransportRequest)request));
        }
    }
}

