/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteTimeoutException;
import io.skylite.common.CheckedFunction;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IllegalIndexShardStateException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.translog.TranslogCorruptedException;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.indices.recovery.BasePeerRecoveryTargetService;
import io.skylite.core.indices.recovery.RecoveryListener;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.indices.replication.common.ReplicationListener;
import io.skylite.core.indices.replication.common.ReplicationTimer;
import io.skylite.core.mapper.MapperException;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.FileChunkRequest;
import org.opensearch.indices.recovery.PeerRecoveryNotFound;
import org.opensearch.indices.recovery.RecoveryCleanFilesRequest;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoveryFilesInfoRequest;
import org.opensearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.opensearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.opensearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoveryTarget;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.opensearch.indices.recovery.ReestablishRecoveryRequest;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.indices.replication.common.ReplicationCollection;

public class PeerRecoveryTargetService
extends BasePeerRecoveryTargetService {
    private static final Logger logger = LogManager.getLogger(PeerRecoveryTargetService.class);
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final ReplicationCollection<RecoveryTarget> onGoingRecoveries;

    public PeerRecoveryTargetService(ThreadPool threadPool, TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
        this.onGoingRecoveries = new ReplicationCollection(logger, threadPool);
        transportService.registerRequestHandler("internal:index/shard/recovery/filesInfo", "generic", RecoveryFilesInfoRequest::new, (TransportRequestHandler)new FilesInfoRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/file_chunk", "generic", FileChunkRequest::new, (TransportRequestHandler)new FileChunkTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/clean_files", "generic", RecoveryCleanFilesRequest::new, (TransportRequestHandler)new CleanFilesRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/prepare_translog", "generic", RecoveryPrepareForTranslogOperationsRequest::new, (TransportRequestHandler)new PrepareForTranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/translog_ops", "generic", RecoveryTranslogOperationsRequest::new, (TransportRequestHandler)new TranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/finalize", "generic", RecoveryFinalizeRecoveryRequest::new, (TransportRequestHandler)new FinalizeRecoveryRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/handoff_primary_context", "generic", RecoveryHandoffPrimaryContextRequest::new, (TransportRequestHandler)new HandoffPrimaryContextRequestHandler());
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable BaseIndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.onGoingRecoveries.cancelForShard(shardId, "shard closed");
        }
    }

    public void startRecovery(BaseIndexShard baseIndexShard, DiscoveryNode sourceNode, RecoveryListener listener) {
        IndexShard indexShard = (IndexShard)baseIndexShard;
        long recoveryId = this.onGoingRecoveries.start(new RecoveryTarget(indexShard, sourceNode, (ReplicationListener)listener, this.threadPool), this.recoverySettings.activityTimeout());
        this.threadPool.generic().execute((Runnable)((Object)new RecoveryRunner(recoveryId)));
    }

    protected void retryRecovery(long recoveryId, Throwable reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace(() -> new ParameterizedMessage("will retry recovery with id [{}] in [{}]", (Object)recoveryId, (Object)retryAfter), reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    protected void retryRecovery(long recoveryId, String reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace("will retry recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    private void retryRecovery(long recoveryId, TimeValue retryAfter, TimeValue activityTimeout) {
        RecoveryTarget newTarget = this.onGoingRecoveries.reset(recoveryId, activityTimeout);
        if (newTarget != null) {
            this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", (Runnable)((Object)new RecoveryRunner(newTarget.getId())));
        }
    }

    protected void reestablishRecovery(StartRecoveryRequest request, String reason, TimeValue retryAfter) {
        long recoveryId = request.recoveryId();
        logger.trace("will try to reestablish recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", (Runnable)((Object)new RecoveryRunner(recoveryId, request)));
    }

    private void doRecovery(long recoveryId, StartRecoveryRequest preExistingRequest) {
        String actionName;
        TransportRequest requestToSend;
        StartRecoveryRequest startRequest;
        ReplicationTimer timer;
        block18: {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = this.onGoingRecoveries.get(recoveryId);){
                if (recoveryRef == null) {
                    logger.trace("not running recovery with id [{}] - can not find it (probably finished)", (Object)recoveryId);
                    return;
                }
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                timer = recoveryTarget.state().getTimer();
                if (preExistingRequest == null) {
                    try {
                        IndexShard indexShard = recoveryTarget.indexShard();
                        indexShard.preRecovery();
                        assert (recoveryTarget.sourceNode() != null) : "can not do a recovery without a source node";
                        logger.trace("{} preparing shard for peer recovery", (Object)recoveryTarget.shardId());
                        indexShard.prepareForIndexRecovery();
                        boolean hasRemoteSegmentStore = indexShard.indexSettings().isRemoteStoreEnabled();
                        if (hasRemoteSegmentStore || indexShard.isRemoteSeeded()) {
                            try {
                                indexShard.syncSegmentsFromRemoteSegmentStore(false, recoveryTarget::setLastAccessTime);
                            }
                            catch (Exception e) {
                                logger.error("Exception while downloading segment files from remote store, will continue with peer to peer segment copy", (Throwable)e);
                            }
                        }
                        boolean hasRemoteTranslog = !recoveryTarget.state().getPrimary() && indexShard.indexSettings().isAssignedOnRemoteNode();
                        boolean hasNoTranslog = indexShard.indexSettings().isRemoteSnapshot();
                        boolean verifyTranslog = !(hasRemoteTranslog || hasNoTranslog || hasRemoteSegmentStore);
                        long startingSeqNo = indexShard.recoverLocallyAndFetchStartSeqNo(!hasRemoteTranslog);
                        assert (startingSeqNo == -2L || recoveryTarget.state().getStage() == RecoveryState.Stage.TRANSLOG) : "unexpected recovery stage [" + String.valueOf(recoveryTarget.state().getStage()) + "] starting seqno [ " + startingSeqNo + "]";
                        startRequest = PeerRecoveryTargetService.getStartRecoveryRequest(logger, this.clusterService.localNode(), recoveryTarget, startingSeqNo, verifyTranslog);
                        requestToSend = startRequest;
                        actionName = "internal:index/shard/recovery/start_recovery";
                    }
                    catch (Exception e) {
                        logger.debug("unexpected error while preparing shard for peer recovery, failing recovery", (Throwable)e);
                        this.onGoingRecoveries.fail(recoveryId, new RecoveryFailedException(recoveryTarget.state(), "failed to prepare shard for recovery", (Throwable)e), true);
                        if (recoveryRef != null) {
                            recoveryRef.close();
                        }
                        return;
                    }
                    logger.debug("{} starting recovery from {}", (Object)startRequest.shardId(), (Object)startRequest.sourceNode());
                    break block18;
                }
                startRequest = preExistingRequest;
                requestToSend = new ReestablishRecoveryRequest(recoveryId, startRequest.shardId(), startRequest.targetAllocationId());
                actionName = "internal:index/shard/recovery/reestablish_recovery";
                logger.debug("{} reestablishing recovery from {}", (Object)startRequest.shardId(), (Object)startRequest.sourceNode());
            }
        }
        this.transportService.sendRequest(startRequest.sourceNode(), actionName, requestToSend, (TransportResponseHandler)new RecoveryResponseHandler(startRequest, timer));
    }

    public static StartRecoveryRequest getStartRecoveryRequest(Logger logger, DiscoveryNode localNode, RecoveryTarget recoveryTarget, long startingSeqNo) {
        return PeerRecoveryTargetService.getStartRecoveryRequest(logger, localNode, recoveryTarget, startingSeqNo, true);
    }

    public static StartRecoveryRequest getStartRecoveryRequest(Logger logger, DiscoveryNode localNode, RecoveryTarget recoveryTarget, long startingSeqNo, boolean verifyTranslog) {
        Store.MetadataSnapshot metadataSnapshot;
        block9: {
            logger.trace("{} collecting local files for [{}]", (Object)recoveryTarget.shardId(), (Object)recoveryTarget.sourceNode());
            try {
                metadataSnapshot = recoveryTarget.indexShard().snapshotStoreMetadata();
                if (!verifyTranslog) break block9;
                try {
                    String expectedTranslogUUID = (String)metadataSnapshot.getCommitUserData().get("translog_uuid");
                    long globalCheckpoint = TranslogStatelessHelper.readGlobalCheckpoint((Path)recoveryTarget.translogLocation(), (String)expectedTranslogUUID);
                    assert (globalCheckpoint + 1L >= startingSeqNo) : "invalid startingSeqNo " + startingSeqNo + " >= " + globalCheckpoint;
                }
                catch (TranslogCorruptedException | IOException e) {
                    logger.warn((Message)new ParameterizedMessage("error while reading global checkpoint from translog, resetting the starting sequence number from {} to unassigned and recovering as if there are none", (Object)startingSeqNo), e);
                    metadataSnapshot = Store.MetadataSnapshot.EMPTY;
                    startingSeqNo = -2L;
                }
            }
            catch (org.apache.lucene.index.IndexNotFoundException e) {
                assert (startingSeqNo == -2L) : startingSeqNo;
                logger.trace("{} shard folder empty, recovering all files", (Object)recoveryTarget);
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
            }
            catch (IOException e) {
                if (startingSeqNo != -2L) {
                    logger.warn((Message)new ParameterizedMessage("error while listing local files, resetting the starting sequence number from {} to unassigned and recovering as if there are none", (Object)startingSeqNo), (Throwable)e);
                    startingSeqNo = -2L;
                } else {
                    logger.warn("error while listing local files, recovering as if there are none", (Throwable)e);
                }
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
            }
        }
        logger.trace("{} local file count [{}]", (Object)recoveryTarget.shardId(), (Object)metadataSnapshot.size());
        StartRecoveryRequest request = new StartRecoveryRequest(recoveryTarget.shardId(), recoveryTarget.indexShard().routingEntry().allocationId().getId(), recoveryTarget.sourceNode(), localNode, metadataSnapshot, recoveryTarget.state().getPrimary(), recoveryTarget.getId(), startingSeqNo);
        return request;
    }

    class FilesInfoRequestHandler
    implements TransportRequestHandler<RecoveryFilesInfoRequest> {
        FilesInfoRequestHandler() {
        }

        public void messageReceived(RecoveryFilesInfoRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/filesInfo", request);
                if (listener == null) {
                    return;
                }
                recoveryTarget.receiveFileInfo(request.phase1FileNames, request.phase1FileSizes, request.phase1ExistingFileNames, request.phase1ExistingFileSizes, request.totalTranslogOps, listener);
            }
        }
    }

    class FileChunkTransportRequestHandler
    implements TransportRequestHandler<FileChunkRequest> {
        final AtomicLong bytesSinceLastPause = new AtomicLong();

        FileChunkTransportRequestHandler() {
        }

        public void messageReceived(FileChunkRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/file_chunk", request);
                recoveryTarget.handleFileChunk(request, recoveryTarget, this.bytesSinceLastPause, PeerRecoveryTargetService.this.recoverySettings.rateLimiter(), listener);
            }
        }
    }

    class CleanFilesRequestHandler
    implements TransportRequestHandler<RecoveryCleanFilesRequest> {
        CleanFilesRequestHandler() {
        }

        public void messageReceived(RecoveryCleanFilesRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/clean_files", request);
                if (listener == null) {
                    return;
                }
                recoveryTarget.cleanFiles(request.totalTranslogOps(), request.getGlobalCheckpoint(), request.sourceMetaSnapshot(), listener);
            }
        }
    }

    class PrepareForTranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryPrepareForTranslogOperationsRequest> {
        PrepareForTranslogOperationsRequestHandler() {
        }

        public void messageReceived(RecoveryPrepareForTranslogOperationsRequest request, TransportChannel channel, Task task) {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/prepare_translog", request);
                if (listener == null) {
                    return;
                }
                recoveryTarget.prepareForTranslogOperations(request.totalTranslogOps(), listener);
            }
        }
    }

    class TranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryTranslogOperationsRequest> {
        TranslogOperationsRequestHandler() {
        }

        public void messageReceived(RecoveryTranslogOperationsRequest request, TransportChannel channel, Task task) throws IOException {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/translog_ops", request, (CheckedFunction<Void, TransportResponse, Exception>)((CheckedFunction)nullVal -> new RecoveryTranslogOperationsResponse(recoveryTarget.indexShard().getLocalCheckpoint())));
                if (listener == null) {
                    return;
                }
                this.performTranslogOps(request, listener, recoveryRef);
            }
        }

        private void performTranslogOps(final RecoveryTranslogOperationsRequest request, final ActionListener<Void> listener, ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef) {
            RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
            ClusterStateObserver observer = new ClusterStateObserver(PeerRecoveryTargetService.this.clusterService, null, logger, PeerRecoveryTargetService.this.threadPool.getThreadContext());
            Consumer<Exception> retryOnMappingException = exception -> {
                logger.debug("delaying recovery due to missing mapping changes", (Throwable)exception);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    public void onNewClusterState(ClusterState state) {
                        PeerRecoveryTargetService.this.threadPool.generic().execute((Runnable)ActionRunnable.wrap((ActionListener)listener, l -> {
                            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                                TranslogOperationsRequestHandler.this.performTranslogOps(request, (ActionListener<Void>)listener, recoveryRef);
                            }
                        }));
                    }

                    public void onClusterServiceClose() {
                        listener.onFailure((Exception)new SkyliteException("cluster service was closed while waiting for mapping updates", new Object[0]));
                    }

                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure((Exception)new SkyliteTimeoutException("timed out waiting for mapping updates (timeout [" + String.valueOf(timeout) + "])", new Object[0]));
                    }
                });
            };
            IndexMetadata indexMetadata = PeerRecoveryTargetService.this.clusterService.state().metadata().index(request.shardId().getIndex());
            long mappingVersionOnTarget = indexMetadata != null ? indexMetadata.getMappingVersion() : 0L;
            recoveryTarget.indexTranslogOperations(request.operations(), request.totalTranslogOps(), request.maxSeenAutoIdTimestampOnPrimary(), request.maxSeqNoOfUpdatesOrDeletesOnPrimary(), request.retentionLeases(), request.mappingVersionOnPrimary(), (ActionListener<Long>)ActionListenerHelper.wrap(checkpoint -> listener.onResponse(null), e -> {
                if (mappingVersionOnTarget < request.mappingVersionOnPrimary() && e instanceof MapperException) {
                    retryOnMappingException.accept((Exception)e);
                } else {
                    listener.onFailure(e);
                }
            }));
        }
    }

    class FinalizeRecoveryRequestHandler
    implements TransportRequestHandler<RecoveryFinalizeRecoveryRequest> {
        FinalizeRecoveryRequestHandler() {
        }

        public void messageReceived(RecoveryFinalizeRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = (RecoveryTarget)recoveryRef.get();
                ActionListener<Void> listener = recoveryTarget.createOrFinishListener(channel, "internal:index/shard/recovery/finalize", request);
                if (listener == null) {
                    return;
                }
                recoveryTarget.finalizeRecovery(request.globalCheckpoint(), request.trimAboveSeqNo(), listener);
            }
        }
    }

    class HandoffPrimaryContextRequestHandler
    implements TransportRequestHandler<RecoveryHandoffPrimaryContextRequest> {
        HandoffPrimaryContextRequestHandler() {
        }

        public void messageReceived(RecoveryHandoffPrimaryContextRequest request, TransportChannel channel, Task task) throws Exception {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getSafe(request.recoveryId(), request.shardId());){
                ((RecoveryTarget)recoveryRef.get()).handoffPrimaryContext(request.primaryContext());
            }
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        }
    }

    class RecoveryRunner
    extends AbstractRunnable {
        final long recoveryId;
        private final StartRecoveryRequest startRecoveryRequest;

        RecoveryRunner(long recoveryId) {
            this(recoveryId, null);
        }

        RecoveryRunner(long recoveryId, StartRecoveryRequest startRecoveryRequest) {
            this.recoveryId = recoveryId;
            this.startRecoveryRequest = startRecoveryRequest;
        }

        public void onFailure(Exception e) {
            try (ReplicationCollection.ReplicationRef<RecoveryTarget> recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.get(this.recoveryId);){
                if (recoveryRef != null) {
                    logger.error(() -> new ParameterizedMessage("unexpected error during recovery [{}], failing shard", (Object)this.recoveryId), (Throwable)e);
                    PeerRecoveryTargetService.this.onGoingRecoveries.fail(this.recoveryId, new RecoveryFailedException(((RecoveryTarget)recoveryRef.get()).state(), "unexpected error", (Throwable)e), true);
                } else {
                    logger.debug(() -> new ParameterizedMessage("unexpected error during recovery, but recovery id [{}] is finished", (Object)this.recoveryId), (Throwable)e);
                }
            }
        }

        public void doRun() {
            PeerRecoveryTargetService.this.doRecovery(this.recoveryId, this.startRecoveryRequest);
        }
    }

    private class RecoveryResponseHandler
    implements TransportResponseHandler<RecoveryResponse> {
        private final long recoveryId;
        private final StartRecoveryRequest request;
        private final ReplicationTimer timer;

        private RecoveryResponseHandler(StartRecoveryRequest request, ReplicationTimer timer) {
            this.recoveryId = request.recoveryId();
            this.request = request;
            this.timer = timer;
        }

        public void handleResponse(RecoveryResponse recoveryResponse) {
            TimeValue recoveryTime = new TimeValue(this.timer.time());
            PeerRecoveryTargetService.this.onGoingRecoveries.markAsDone(this.recoveryId);
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(this.request.shardId().getIndex().getName()).append(']').append('[').append(this.request.shardId().id()).append("] ");
                sb.append("recovery completed from ").append(this.request.sourceNode()).append(", took[").append(recoveryTime).append("]\n");
                sb.append("   phase1: recovered_files [").append(recoveryResponse.phase1FileNames.size()).append("]").append(" with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1TotalSize)).append("]").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1Time)).append("], throttling_wait [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1ThrottlingWaitTime)).append(']').append("\n");
                sb.append("         : reusing_files   [").append(recoveryResponse.phase1ExistingFileNames.size()).append("] with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1ExistingTotalSize)).append("]\n");
                sb.append("   phase2: start took [").append(TimeValue.timeValueMillis((long)recoveryResponse.startTime)).append("]\n");
                sb.append("         : recovered [").append(recoveryResponse.phase2Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase2Time)).append("]").append("\n");
                logger.trace("{}", (Object)sb);
            } else {
                logger.debug("{} recovery done from [{}], took [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)recoveryTime);
            }
        }

        public void handleException(TransportException e) {
            this.onException((Exception)e);
        }

        private void onException(Exception e) {
            Throwable cause;
            if (logger.isTraceEnabled()) {
                logger.trace(() -> new ParameterizedMessage("[{}][{}] Got exception on recovery", (Object)this.request.shardId().getIndex().getName(), (Object)this.request.shardId().id()), (Throwable)e);
            }
            if ((cause = SkyliteExceptionsHelper.unwrapCause((Throwable)e)) instanceof CancellableThreads.ExecutionCancelledException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.fail(this.recoveryId, new RecoveryFailedException(this.request, "source has canceled the recovery", cause), false);
                return;
            }
            if (cause instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if ((cause = SkyliteExceptionsHelper.unwrapCause((Throwable)cause)) instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if (cause instanceof IllegalIndexShardStateException || cause instanceof IndexNotFoundException || cause instanceof ShardNotFoundException) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, "remote shard not ready", PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof DelayRecoveryException || cause instanceof PeerRecoveryNotFound) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, cause, PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof ConnectTransportException) {
                logger.info("recovery of {} from [{}] interrupted by network disconnect, will retry in [{}]; cause: [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork(), (Object)cause.getMessage());
                PeerRecoveryTargetService.this.reestablishRecovery(this.request, cause.getMessage(), PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork());
                return;
            }
            if (cause instanceof AlreadyClosedException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.fail(this.recoveryId, new RecoveryFailedException(this.request, "source shard is closed", cause), false);
                return;
            }
            PeerRecoveryTargetService.this.onGoingRecoveries.fail(this.recoveryId, new RecoveryFailedException(this.request, e), true);
        }

        public String executor() {
            return "generic";
        }

        public RecoveryResponse read(StreamInput in) throws IOException {
            return new RecoveryResponse(in);
        }
    }
}

