/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.seqno.ReplicationTracker;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.transport.TransportRequest;
import java.io.IOException;

class RecoveryHandoffPrimaryContextRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private ReplicationTracker.PrimaryContext primaryContext;

    RecoveryHandoffPrimaryContextRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.primaryContext = new ReplicationTracker.PrimaryContext(in);
    }

    RecoveryHandoffPrimaryContextRequest(long recoveryId, ShardId shardId, ReplicationTracker.PrimaryContext primaryContext) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.primaryContext = primaryContext;
    }

    long recoveryId() {
        return this.recoveryId;
    }

    ShardId shardId() {
        return this.shardId;
    }

    ReplicationTracker.PrimaryContext primaryContext() {
        return this.primaryContext;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        this.primaryContext.writeTo(out);
    }

    public String toString() {
        return "RecoveryHandoffPrimaryContextRequest{recoveryId=" + this.recoveryId + ", shardId=" + String.valueOf(this.shardId) + ", primaryContext=" + String.valueOf(this.primaryContext) + "}";
    }
}

