/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.common.Assertions;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.flush.FlushRequest;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.seqno.ReplicationTracker;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardNotRecoveringException;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.indices.replication.common.ReplicationFailedException;
import io.skylite.core.indices.replication.common.ReplicationListener;
import io.skylite.core.indices.replication.common.ReplicationLuceneIndex;
import io.skylite.core.indices.replication.common.ReplicationState;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.mapper.MapperException;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.Directory;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.replication.common.ReplicationTarget;

public class RecoveryTarget
extends ReplicationTarget
implements RecoveryTargetHandler {
    private static final String RECOVERY_PREFIX = "recovery.";
    private final DiscoveryNode sourceNode;
    protected final MultiFileWriter multiFileWriter;
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private final ThreadPool threadPool;

    public RecoveryTarget(BaseIndexShard indexShard, DiscoveryNode sourceNode, ReplicationListener listener, ThreadPool threadPool) {
        super("recovery_status", indexShard, indexShard.recoveryState().getIndex(), listener);
        this.sourceNode = sourceNode;
        this.threadPool = threadPool;
        ((IndexShard)indexShard).recoveryStats().incCurrentAsTarget();
        String tempFilePrefix = this.getPrefix() + UUIDs.randomBase64UUID() + ".";
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, tempFilePrefix, this.logger, () -> this.ensureRefCount());
    }

    @Override
    public RecoveryTarget retryCopy() {
        return new RecoveryTarget(this.indexShard, this.sourceNode, this.listener, this.threadPool);
    }

    public String source() {
        return this.sourceNode.toString();
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public RecoveryState state() {
        return this.indexShard.recoveryState();
    }

    @Override
    public CancellableThreads cancellableThreads() {
        return this.cancellableThreads;
    }

    @Override
    public String description() {
        return "recovery from " + this.source();
    }

    @Override
    public void notifyListener(ReplicationFailedException e, boolean sendShardFailure) {
        this.listener.onFailure((ReplicationState)this.state(), (ReplicationFailedException)new RecoveryFailedException(this.state(), e.getMessage(), (Throwable)e), sendShardFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        long recoveryId = this.getId();
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("reset of recovery with shard {} and id [{}]", (Object)this.shardId(), (Object)recoveryId);
            }
            finally {
                this.decRef();
            }
            try {
                newTargetCancellableThreads.execute(this.closedLatch::await);
            }
            catch (CancellableThreads.ExecutionCancelledException e) {
                this.logger.trace("new recovery target cancelled for shard {} while waiting on old recovery target with id [{}] to close", (Object)this.shardId(), (Object)recoveryId);
                return false;
            }
            RecoveryState.Stage stage = this.indexShard.recoveryState().getStage();
            if (this.indexShard.recoveryState().getPrimary() && (stage == RecoveryState.Stage.FINALIZE || stage == RecoveryState.Stage.DONE)) {
                assert (stage != RecoveryState.Stage.DONE) : "recovery should not have completed when it's being reset";
                throw new IllegalStateException("cannot reset recovery as previous attempt made it past finalization step");
            }
            this.indexShard.performRecoveryRestart();
            return true;
        }
        return false;
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            this.store.decRef();
            this.indexShard.recoveryStats().decCurrentAsTarget();
            this.closedLatch.countDown();
        }
    }

    public String toString() {
        return String.valueOf(this.shardId()) + " [" + this.getId() + "]";
    }

    @Override
    protected String getPrefix() {
        return RECOVERY_PREFIX;
    }

    @Override
    protected void onDone() {
        assert (this.multiFileWriter.tempFileNames.isEmpty()) : "not all temporary files are renamed";
        this.indexShard.postRecovery("peer recovery done");
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.state().getIndex().setFileDetailsComplete();
            this.state().getTranslog().totalOperations(totalTranslogOps);
            if (this.indexShard.shouldSeedRemoteStore()) {
                assert (this.indexShard.routingEntry().primary()) : "Remote seeding should only true be for primary shard copy";
                this.indexShard.deleteRemoteStoreContents();
            }
            this.indexShard().openEngineAndSkipTranslogRecovery();
            if (this.indexShard.shouldSeedRemoteStore()) {
                this.indexShard.sync();
                this.threadPool.executor("generic").execute(() -> this.indexShard.refresh("remote store migration"));
                this.indexShard.waitForRemoteStoreSync(this::setLastAccessTime);
                this.logger.info("Remote Store is now seeded for {}", (Object)this.indexShard.shardId());
            }
            return null;
        });
    }

    @Override
    public void forceSegmentFileSync() {
        throw new UnsupportedOperationException("Method not supported on target!");
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.indexShard.updateGlobalCheckpointOnReplica(globalCheckpoint, "finalizing recovery");
            this.indexShard.sync();
            this.indexShard.persistRetentionLeases();
            if (trimAboveSeqNo != -2L) {
                this.indexShard.rollTranslogGeneration();
                this.indexShard.afterWriteOperation();
                this.indexShard.trimOperationOfPreviousPrimaryTerms(trimAboveSeqNo);
            }
            if (this.hasUncommittedOperations()) {
                this.indexShard.flush(new FlushRequest(new String[0]).force(true).waitIfOngoing(true));
            }
            this.indexShard.finalizeRecovery();
            return null;
        });
    }

    private boolean hasUncommittedOperations() throws IOException {
        long localCheckpointOfCommit = Long.parseLong((String)this.indexShard.commitStats().getUserData().get("local_checkpoint"));
        return this.indexShard.countNumberOfHistoryOperations("peer-recovery", localCheckpointOfCommit + 1L, Long.MAX_VALUE) > 0;
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.indexShard.activateWithPrimaryContext(primaryContext);
    }

    @Override
    public void indexTranslogOperations(List<TranslogOperation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            RecoveryState.Translog translog = this.state().getTranslog();
            translog.totalOperations(totalTranslogOps);
            assert (this.indexShard().recoveryState() == this.state());
            if (this.indexShard().state() != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId(), this.indexShard().state());
            }
            this.indexShard().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampOnPrimary);
            this.indexShard().advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfDeletesOrUpdatesOnPrimary);
            this.indexShard().updateRetentionLeasesOnReplica(retentionLeases);
            for (TranslogOperation operation : operations) {
                EngineResult result = this.indexShard().applyTranslogOperation(operation, EngineOperation.Origin.PEER_RECOVERY);
                if (result.getResultType() == EngineResult.Type.MAPPING_UPDATE_REQUIRED) {
                    throw new MapperException("mapping updates are not allowed [" + String.valueOf(operation) + "]");
                }
                if (result.getFailure() == null) continue;
                if (Assertions.ENABLED && !(result.getFailure() instanceof MapperException)) {
                    throw new AssertionError("unexpected failure while replicating translog entry", result.getFailure());
                }
                ExceptionsHelper.reThrowIfNotNull((Throwable)result.getFailure());
            }
            translog.incrementRecoveredOperations(operations.size());
            this.indexShard().sync();
            this.indexShard().afterWriteOperation();
            return this.indexShard().getLocalCheckpoint();
        });
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            int i;
            this.indexShard.resetRecoveryStage();
            this.indexShard.prepareForIndexRecovery();
            ReplicationLuceneIndex index = this.state().getIndex();
            for (i = 0; i < phase1ExistingFileNames.size(); ++i) {
                index.addFileDetail((String)phase1ExistingFileNames.get(i), ((Long)phase1ExistingFileSizes.get(i)).longValue(), true);
            }
            for (i = 0; i < phase1FileNames.size(); ++i) {
                index.addFileDetail((String)phase1FileNames.get(i), ((Long)phase1FileSizes.get(i)).longValue(), false);
            }
            index.setFileDetailsComplete();
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.state().getTranslog().totalOperationsOnStart(totalTranslogOps);
            return null;
        });
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.multiFileWriter.renameAllTempFiles();
            Store store = this.store();
            store.incRef();
            try {
                boolean reuseTranslogUUID;
                store.cleanupAndVerify("recovery CleanFilesRequestHandler", sourceMetadata);
                boolean bl = reuseTranslogUUID = this.indexShard.indexSettings().isSegRepEnabledOrRemoteNode() || this.indexShard.indexSettings().isRemoteSnapshot();
                if (reuseTranslogUUID) {
                    String translogUUID = (String)store.getMetadata().getCommitUserData().get("translog_uuid");
                    Translog.createEmptyTranslog((Path)this.indexShard.shardPath().resolveTranslog(), (ShardId)this.shardId(), (long)globalCheckpoint, (long)this.indexShard.getPendingPrimaryTerm(), (String)translogUUID, FileChannel::open);
                } else {
                    String translogUUID = Translog.createEmptyTranslog((Path)this.indexShard.shardPath().resolveTranslog(), (long)globalCheckpoint, (ShardId)this.shardId(), (long)this.indexShard.getPendingPrimaryTerm());
                    store.associateIndexWithNewTranslog(translogUUID);
                }
                if (this.indexShard.getRetentionLeases().leases().isEmpty()) {
                    this.indexShard.persistRetentionLeases();
                    assert (this.indexShard.loadRetentionLeases().leases().isEmpty());
                } else assert (this.indexShard.assertRetentionLeasesPersisted());
                this.indexShard.maybeCheckIndex();
                this.state().setStage(RecoveryState.Stage.TRANSLOG);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                try {
                    try {
                        store.removeCorruptionMarker();
                    }
                    finally {
                        Lucene.cleanLuceneIndex((Directory)store.directory());
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Failed to clean lucene index", (Throwable)e);
                    ex.addSuppressed(e);
                }
                RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", ex);
                this.fail(rfe, true);
                throw rfe;
            }
            catch (Exception ex) {
                RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", (Throwable)ex);
                this.fail(rfe, true);
                throw rfe;
            }
            finally {
                store.decRef();
            }
            return null;
        });
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.multiFileWriter.writeFileChunk(fileMetadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public String getTempNameForFile(String origFile) {
        return this.multiFileWriter.getTempNameForFile(origFile);
    }

    Path translogLocation() {
        return this.indexShard().shardPath().resolveTranslog();
    }
}

