/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.index.translog.TranslogOperation;
import java.io.IOException;
import java.util.List;
import org.opensearch.indices.recovery.RecoveryTransportRequest;

public class RecoveryTranslogOperationsRequest
extends RecoveryTransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final List<TranslogOperation> operations;
    private final int totalTranslogOps;
    private final long maxSeenAutoIdTimestampOnPrimary;
    private final long maxSeqNoOfUpdatesOrDeletesOnPrimary;
    private final RetentionLeases retentionLeases;
    private final long mappingVersionOnPrimary;

    RecoveryTranslogOperationsRequest(long recoveryId, long requestSeqNo, ShardId shardId, List<TranslogOperation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfUpdatesOrDeletesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary) {
        super(requestSeqNo);
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.operations = operations;
        this.totalTranslogOps = totalTranslogOps;
        this.maxSeenAutoIdTimestampOnPrimary = maxSeenAutoIdTimestampOnPrimary;
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = maxSeqNoOfUpdatesOrDeletesOnPrimary;
        this.retentionLeases = retentionLeases;
        this.mappingVersionOnPrimary = mappingVersionOnPrimary;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public List<TranslogOperation> operations() {
        return this.operations;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long maxSeenAutoIdTimestampOnPrimary() {
        return this.maxSeenAutoIdTimestampOnPrimary;
    }

    public long maxSeqNoOfUpdatesOrDeletesOnPrimary() {
        return this.maxSeqNoOfUpdatesOrDeletesOnPrimary;
    }

    public RetentionLeases retentionLeases() {
        return this.retentionLeases;
    }

    long mappingVersionOnPrimary() {
        return this.mappingVersionOnPrimary;
    }

    RecoveryTranslogOperationsRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.operations = Translog.readOperations((StreamInput)in, (String)"recovery");
        this.totalTranslogOps = in.readVInt();
        this.maxSeenAutoIdTimestampOnPrimary = in.readZLong();
        this.maxSeqNoOfUpdatesOrDeletesOnPrimary = in.readZLong();
        this.retentionLeases = new RetentionLeases(in);
        this.mappingVersionOnPrimary = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        Translog.writeOperations((StreamOutput)out, this.operations);
        out.writeVInt(this.totalTranslogOps);
        out.writeZLong(this.maxSeenAutoIdTimestampOnPrimary);
        out.writeZLong(this.maxSeqNoOfUpdatesOrDeletesOnPrimary);
        this.retentionLeases.writeTo(out);
        out.writeVLong(this.mappingVersionOnPrimary);
    }
}

