/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.Map;

public class CheckpointInfoResponse
extends TransportResponse {
    private final ReplicationCheckpoint checkpoint;
    private final Map<String, StoreFileMetadata> metadataMap;
    private final byte[] infosBytes;

    public CheckpointInfoResponse(ReplicationCheckpoint checkpoint, Map<String, StoreFileMetadata> metadataMap, byte[] infosBytes) {
        this.checkpoint = checkpoint;
        this.metadataMap = metadataMap;
        this.infosBytes = infosBytes;
    }

    public CheckpointInfoResponse(StreamInput in) throws IOException {
        this.checkpoint = new ReplicationCheckpoint(in);
        this.metadataMap = in.readMap(StreamInput::readString, StoreFileMetadata::new);
        this.infosBytes = in.readByteArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.checkpoint.writeTo(out);
        out.writeMap(this.metadataMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
        out.writeByteArray(this.infosBytes);
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Map<String, StoreFileMetadata> getMetadataMap() {
        return this.metadataMap;
    }

    public byte[] getInfosBytes() {
        return this.infosBytes;
    }
}

