/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.common.action.ActionListener;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.util.ChecksumUtil;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.store.remote.metadata.RemoteSegmentMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.util.Version;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;

public class RemoteStoreReplicationSource
implements SegmentReplicationSource {
    private static final Logger logger = LogManager.getLogger(RemoteStoreReplicationSource.class);
    private final BaseIndexShard indexShard;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final CancellableThreads cancellableThreads = new CancellableThreads();

    public RemoteStoreReplicationSource(BaseIndexShard indexShard) {
        this.indexShard = indexShard;
        FilterDirectory remoteStoreDirectory = (FilterDirectory)indexShard.remoteStore().directory();
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)byteSizeCachingStoreDirectory.getDelegate();
    }

    @Override
    public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
        try (GatedCloseable segmentInfosSnapshot = this.indexShard.getSegmentInfosSnapshot();){
            Version version = ((SegmentInfos)segmentInfosSnapshot.get()).getCommitLuceneVersion();
            RemoteSegmentMetadata mdFile = this.getRemoteSegmentMetadata();
            if (mdFile == null && !this.indexShard.state().equals((Object)IndexShardState.STARTED)) {
                listener.onResponse((Object)new CheckpointInfoResponse(checkpoint, Collections.emptyMap(), null));
                return;
            }
            assert (mdFile != null) : "Remote metadata file can't be null if shard is active " + String.valueOf(this.indexShard.state());
            Map<String, StoreFileMetadata> metadataMap = mdFile.getMetadata().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new StoreFileMetadata(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getOriginalFilename(), ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getLength(), ChecksumUtil.digestToString((long)Long.valueOf(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getChecksum())), version, null)));
            listener.onResponse((Object)new CheckpointInfoResponse(mdFile.getReplicationCheckpoint(), metadataMap, mdFile.getSegmentInfosBytes()));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @Override
    public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, BaseIndexShard baseIndexShard, BiConsumer<String, Long> fileProgressTracker, ActionListener<GetSegmentFilesResponse> listener) {
        try {
            IndexShard indexShard = (IndexShard)baseIndexShard;
            if (filesToFetch.isEmpty()) {
                listener.onResponse((Object)new GetSegmentFilesResponse(Collections.emptyList()));
                return;
            }
            logger.debug("Downloading segment files from remote store {}", filesToFetch);
            if (this.remoteMetadataExists()) {
                Directory storeDirectory = indexShard.store().directory();
                List<String> directoryFiles = List.of(storeDirectory.listAll());
                ArrayList<String> toDownloadSegmentNames = new ArrayList<String>();
                for (StoreFileMetadata fileMetadata : filesToFetch) {
                    String file = fileMetadata.name();
                    assert (!directoryFiles.contains(file)) : "Local store already contains the file " + file;
                    toDownloadSegmentNames.add(file);
                }
                indexShard.getFileDownloader().downloadAsync(this.cancellableThreads, (Directory)this.remoteDirectory, (Directory)new SegmentReplicationSource.ReplicationStatsDirectoryWrapper(storeDirectory, fileProgressTracker), toDownloadSegmentNames, (ActionListener<Void>)ActionListenerHelper.map(listener, r -> new GetSegmentFilesResponse(filesToFetch)));
            } else {
                listener.onResponse((Object)new GetSegmentFilesResponse(filesToFetch));
            }
        }
        catch (IOException | RuntimeException e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void cancel() {
        this.cancellableThreads.cancel("Canceled by target");
    }

    @Override
    public String getDescription() {
        return "RemoteStoreReplicationSource";
    }

    private boolean remoteMetadataExists() throws IOException {
        AtomicBoolean metadataExists = new AtomicBoolean(false);
        this.cancellableThreads.executeIO(() -> metadataExists.set(this.remoteDirectory.readLatestMetadataFile() != null));
        return metadataExists.get();
    }

    private RemoteSegmentMetadata getRemoteSegmentMetadata() throws IOException {
        AtomicReference mdFile = new AtomicReference();
        this.cancellableThreads.executeIO(() -> mdFile.set(this.remoteDirectory.init()));
        return (RemoteSegmentMetadata)mdFile.get();
    }
}

