/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.transport.TransportService;
import org.opensearch.indices.replication.PrimaryShardReplicationSource;
import org.opensearch.indices.replication.RemoteStoreReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationSource;

public class SegmentReplicationSourceFactory {
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;

    public SegmentReplicationSourceFactory(TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService) {
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
    }

    public SegmentReplicationSource get(BaseIndexShard shard) {
        if (shard.indexSettings().isAssignedOnRemoteNode()) {
            return new RemoteStoreReplicationSource(shard);
        }
        return new PrimaryShardReplicationSource(shard.recoveryState().getTargetNode(), shard.routingEntry().allocationId().getId(), this.transportService, this.recoverySettings, this.getPrimaryNode(shard.shardId()));
    }

    private DiscoveryNode getPrimaryNode(ShardId shardId) {
        ShardRouting primaryShard = this.clusterService.state().routingTable().shardRoutingTable(shardId).primaryShard();
        return this.clusterService.state().nodes().get(primaryShard.currentNodeId());
    }
}

