/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.shard.BaseIndexShard;
import java.util.Objects;
import java.util.function.BiFunction;
import org.opensearch.indices.replication.checkpoint.PublishCheckpointAction;

public class SegmentReplicationCheckpointPublisher
implements BiFunction<BaseIndexShard, ReplicationCheckpoint, Void> {
    private final PublishAction publishAction;
    public static final SegmentReplicationCheckpointPublisher EMPTY = new SegmentReplicationCheckpointPublisher((indexShard, checkpoint) -> {});

    @Inject
    public SegmentReplicationCheckpointPublisher(PublishCheckpointAction publishAction) {
        this(publishAction::publish);
    }

    public SegmentReplicationCheckpointPublisher(PublishAction publishAction) {
        this.publishAction = Objects.requireNonNull(publishAction);
    }

    public Void publish(BaseIndexShard indexShard, ReplicationCheckpoint checkpoint) {
        this.publishAction.publish(indexShard, checkpoint);
        indexShard.onCheckpointPublished(checkpoint);
        return null;
    }

    @Override
    public Void apply(BaseIndexShard baseIndexShard, ReplicationCheckpoint replicationCheckpoint) {
        return this.publish(baseIndexShard, replicationCheckpoint);
    }

    public static interface PublishAction {
        public void publish(BaseIndexShard var1, ReplicationCheckpoint var2);
    }
}

