/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import io.skylite.SkyliteException;
import io.skylite.common.CheckedFunction;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.AbstractRefCounted;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.Loggers;
import io.skylite.core.common.util.CancellableThreads;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.indices.replication.common.ReplicationFailedException;
import io.skylite.core.indices.replication.common.ReplicationListener;
import io.skylite.core.indices.replication.common.ReplicationLuceneIndex;
import io.skylite.core.indices.replication.common.ReplicationState;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.RateLimiter;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.FileChunkRequest;
import org.opensearch.indices.recovery.RecoveryTransportRequest;
import org.opensearch.indices.replication.common.ReplicationRequestTracker;

public abstract class ReplicationTarget
extends AbstractRefCounted {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private volatile long lastAccessTime = System.nanoTime();
    private final ReplicationRequestTracker requestTracker = new ReplicationRequestTracker();
    private final long id;
    protected final AtomicBoolean finished = new AtomicBoolean();
    protected final IndexShard indexShard;
    protected final Store store;
    protected final ReplicationListener listener;
    protected final Logger logger;
    protected final CancellableThreads cancellableThreads;
    protected final ReplicationLuceneIndex stateIndex;

    protected abstract String getPrefix();

    protected abstract void onDone();

    protected void onCancel(String reason) {
        this.cancellableThreads.cancel(reason);
    }

    public abstract ReplicationState state();

    public abstract ReplicationTarget retryCopy();

    public abstract String description();

    public ReplicationListener getListener() {
        return this.listener;
    }

    public CancellableThreads cancellableThreads() {
        return this.cancellableThreads;
    }

    public abstract void notifyListener(ReplicationFailedException var1, boolean var2);

    public ReplicationTarget(String name, BaseIndexShard indexShard, ReplicationLuceneIndex stateIndex, ReplicationListener listener) {
        super(name);
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)indexShard.shardId(), (String[])new String[0]);
        this.listener = listener;
        this.id = ID_GENERATOR.incrementAndGet();
        this.stateIndex = stateIndex;
        this.indexShard = (IndexShard)indexShard;
        this.store = indexShard.store();
        this.cancellableThreads = new CancellableThreads();
        this.store.incRef();
        if (indexShard.indexSettings().isRemoteStoreEnabled()) {
            indexShard.remoteStore().incRef();
        }
    }

    public long getId() {
        return this.id;
    }

    public abstract boolean reset(CancellableThreads var1) throws IOException;

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.nanoTime();
    }

    @Nullable
    public ActionListener<Void> markRequestReceivedAndCreateListener(long requestSeqNo, ActionListener<Void> listener) {
        return this.requestTracker.markReceivedAndCreateListener(requestSeqNo, listener);
    }

    public IndexShard indexShard() {
        this.ensureRefCount();
        return this.indexShard;
    }

    public Store store() {
        this.ensureRefCount();
        return this.store;
    }

    public ShardId shardId() {
        return this.indexShard.shardId();
    }

    public void markAsDone() {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.onDone();
            }
            finally {
                this.decRef();
            }
            this.listener.onDone(this.state());
        }
    }

    public void cancel(String reason) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("replication/recovery cancelled (reason: [{}])", (Object)reason);
                this.onCancel(reason);
            }
            finally {
                this.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ReplicationFailedException e, boolean sendShardFailure) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("marking target " + this.description() + " as failed", (Throwable)e);
                this.notifyListener(e, sendShardFailure);
            }
            finally {
                try {
                    this.cancellableThreads.cancel("failed" + this.description() + "[" + ExceptionsHelper.stackTrace((Throwable)e) + "]");
                }
                finally {
                    this.decRef();
                }
            }
        }
    }

    protected void ensureRefCount() {
        if (this.refCount() <= 0) {
            throw new SkyliteException("ReplicationTarget is used but it's refcount is 0. Probably a mismatch between incRef/decRef calls", new Object[0]);
        }
    }

    @Nullable
    public ActionListener<Void> createOrFinishListener(TransportChannel channel, String action, RecoveryTransportRequest request) {
        return this.createOrFinishListener(channel, action, request, (CheckedFunction<Void, TransportResponse, Exception>)((CheckedFunction)nullVal -> TransportResponse.Empty.INSTANCE));
    }

    @Nullable
    public ActionListener<Void> createOrFinishListener(TransportChannel channel, String action, RecoveryTransportRequest request, CheckedFunction<Void, TransportResponse, Exception> responseFn) {
        ChannelActionListener channelListener = new ChannelActionListener(channel, action, (TransportRequest)request);
        ActionListener<Void> voidListener = ActionListenerHelper.map((ActionListener)channelListener, responseFn);
        long requestSeqNo = request.requestSeqNo();
        ActionListener<Void> listener = requestSeqNo != -2L ? this.markRequestReceivedAndCreateListener(requestSeqNo, voidListener) : voidListener;
        return listener;
    }

    public void handleFileChunk(FileChunkRequest request, ReplicationTarget replicationTarget, AtomicLong bytesSinceLastPause, RateLimiter rateLimiter, ActionListener<Void> listener) throws IOException {
        long bytes;
        if (listener == null) {
            return;
        }
        ReplicationLuceneIndex indexState = replicationTarget.state().getIndex();
        if (request.sourceThrottleTimeInNanos() != -1L) {
            indexState.addSourceThrottling(request.sourceThrottleTimeInNanos());
        }
        if (rateLimiter != null && (bytes = bytesSinceLastPause.addAndGet(request.content().length())) > rateLimiter.getMinPauseCheckBytes()) {
            bytesSinceLastPause.addAndGet(-bytes);
            long throttleTimeInNanos = rateLimiter.pause(bytes);
            indexState.addTargetThrottling(throttleTimeInNanos);
            replicationTarget.indexShard().recoveryStats().addThrottleTime(throttleTimeInNanos);
        }
        this.writeFileChunk(request.metadata(), request.position(), request.content(), request.lastChunk(), request.totalTranslogOps(), listener);
    }

    public abstract void writeFileChunk(StoreFileMetadata var1, long var2, BytesReference var4, boolean var5, int var6, ActionListener<Void> var7);

    protected void closeInternal() {
        try {
            this.store.decRef();
        }
        finally {
            if (this.indexShard.indexSettings().isRemoteStoreEnabled()) {
                this.indexShard.remoteStore().decRef();
            }
        }
    }
}

