/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.store;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.store.ShardAttributes;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;

public class TransportNodesListShardStoreMetadata
extends TransportNodesAction<Request, NodesStoreFilesMetadata, NodeRequest, NodeStoreFilesMetadata>
implements AsyncShardFetch.Lister<NodesStoreFilesMetadata, NodeStoreFilesMetadata> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store";
    public static final ActionType<NodesStoreFilesMetadata> TYPE = new ActionType("internal:cluster/nodes/indices/shard/store", NodesStoreFilesMetadata::new);
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetadata(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetadata.class);
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributes, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetadata> listener) {
        assert (shardAttributes.size() == 1) : "only one shard should be specified";
        ShardId shardId = shardAttributes.keySet().iterator().next();
        String customDataPath = shardAttributes.get(shardId).getCustomDataPath();
        this.execute((ActionRequest)new Request(shardId, customDataPath, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeStoreFilesMetadata newNodeResponse(StreamInput in) throws IOException {
        return new NodeStoreFilesMetadata(in);
    }

    @Override
    protected NodesStoreFilesMetadata newResponse(Request request, List<NodeStoreFilesMetadata> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetadata(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetadata nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetadata(this.clusterService.localNode(), this.listStoreMetadata(request));
        }
        catch (IOException e) {
            throw new SkyliteException("Failed to list store metadata for shard [" + String.valueOf(request.shardId) + "]", (Throwable)e, new Object[0]);
        }
    }

    private TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata listStoreMetadata(NodeRequest request) throws IOException {
        ShardId shardId = request.getShardId();
        return TransportNodesListShardStoreMetadataHelper.listShardMetadataInternal(this.logger, shardId, this.nodeEnv, this.indicesService, request.getCustomDataPath(), this.settings, this.clusterService);
    }

    public static class NodeStoreFilesMetadata
    extends BaseNodeResponse {
        private TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata;

        public NodeStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
            this.storeFilesMetadata = new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(in);
        }

        public NodeStoreFilesMetadata(DiscoveryNode node, TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata) {
            super(node);
            this.storeFilesMetadata = storeFilesMetadata;
        }

        public TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata() {
            return this.storeFilesMetadata;
        }

        public static NodeStoreFilesMetadata readListShardStoreNodeOperationResponse(StreamInput in) throws IOException {
            return new NodeStoreFilesMetadata(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.storeFilesMetadata.writeTo(out);
        }

        public String toString() {
            return "[[" + String.valueOf(this.getNode()) + "][" + String.valueOf(this.storeFilesMetadata) + "]]";
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public Request(ShardId shardId, String customDataPath, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardId = Objects.requireNonNull(shardId);
            this.customDataPath = Objects.requireNonNull(customDataPath);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.customDataPath);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final ShardId shardId;
        @Nullable
        private final String customDataPath;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.customDataPath = in.readString();
        }

        public NodeRequest(Request request) {
            this.shardId = Objects.requireNonNull(request.shardId());
            this.customDataPath = Objects.requireNonNull(request.getCustomDataPath());
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            assert (this.customDataPath != null);
            out.writeString(this.customDataPath);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Nullable
        public String getCustomDataPath() {
            return this.customDataPath;
        }
    }

    public static class NodesStoreFilesMetadata
    extends BaseNodesResponse<NodeStoreFilesMetadata> {
        public NodesStoreFilesMetadata(StreamInput in) throws IOException {
            super(in);
        }

        public NodesStoreFilesMetadata(ClusterName clusterName, List<NodeStoreFilesMetadata> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeStoreFilesMetadata> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetadata::readListShardStoreNodeOperationResponse);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetadata> nodes) throws IOException {
            out.writeList(nodes);
        }
    }
}

