/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor;

import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.monitor.jvm.JvmGcMonitorService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.monitor.os.OsService;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import org.opensearch.monitor.fs.FsService;
import org.opensearch.monitor.process.ProcessService;

public class MonitorService
extends AbstractLifecycleComponent {
    private final JvmGcMonitorService jvmGcMonitorService;
    private final OsService osService;
    private final ProcessService processService;
    private final JvmService jvmService;
    private final FsService fsService;

    public MonitorService(Settings settings, NodeEnvironment nodeEnvironment, ThreadPool threadPool, FileCache fileCache) throws IOException {
        this.jvmGcMonitorService = new JvmGcMonitorService(settings, threadPool);
        this.osService = new OsService(settings);
        this.processService = new ProcessService(settings);
        this.jvmService = new JvmService(settings);
        this.fsService = new FsService(settings, nodeEnvironment, fileCache);
    }

    public OsService osService() {
        return this.osService;
    }

    public ProcessService processService() {
        return this.processService;
    }

    public JvmService jvmService() {
        return this.jvmService;
    }

    public FsService fsService() {
        return this.fsService;
    }

    protected void doStart() {
        this.jvmGcMonitorService.start();
    }

    protected void doStop() {
        this.jvmGcMonitorService.stop();
    }

    protected void doClose() {
        this.jvmGcMonitorService.close();
    }
}

