/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.process;

import io.skylite.common.SingleObjectCache;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.monitor.process.ProcessInfo;
import io.skylite.core.monitor.process.ProcessProbe;
import io.skylite.core.monitor.process.ProcessStats;
import io.skylite.core.service.ReportingService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProcessService
implements ReportingService<ProcessInfo> {
    private static final Logger logger = LogManager.getLogger(ProcessService.class);
    private final ProcessProbe probe = ProcessProbe.getInstance();
    private final ProcessInfo info;
    private final SingleObjectCache<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting((String)"monitor.process.refresh_interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public ProcessService(Settings settings) {
        TimeValue refreshInterval = (TimeValue)REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = new ProcessStatsCache(refreshInterval, this.probe.processStats());
        this.info = this.probe.processInfo(refreshInterval.millis());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public ProcessInfo info() {
        return this.info;
    }

    public ProcessStats stats() {
        return (ProcessStats)this.processStatsCache.getOrRefresh();
    }

    private class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, (Object)initValue);
        }

        protected ProcessStats refresh() {
            return ProcessService.this.probe.processStats();
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(REFRESH_INTERVAL_SETTING);
        }
    }
}

