/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import io.lucenia.action.ActionModule;
import io.lucenia.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import io.lucenia.action.bulk.TransportBulkAction;
import io.lucenia.action.search.SearchExecutionStatsCollector;
import io.lucenia.action.update.UpdateHelper;
import io.lucenia.common.network.NetworkModule;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.CircuitBreakerPlugin;
import io.lucenia.plugins.ClusterPlugin;
import io.lucenia.plugins.DiscoveryPlugin;
import io.lucenia.plugins.EnginePlugin;
import io.lucenia.plugins.ExtensionAwarePlugin;
import io.lucenia.plugins.MetadataUpgrader;
import io.lucenia.plugins.NetworkPlugin;
import io.lucenia.plugins.PersistentTaskPlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.PluginsService;
import io.lucenia.plugins.RepositoryPlugin;
import io.lucenia.plugins.ScriptPlugin;
import io.lucenia.plugins.SearchPlugin;
import io.lucenia.plugins.SystemIndexPlugin;
import io.lucenia.plugins.TelemetryAwarePlugin;
import io.lucenia.plugins.TelemetryPlugin;
import io.skylite.Build;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteTimeoutException;
import io.skylite.Version;
import io.skylite.common.Assertions;
import io.skylite.common.SetOnce;
import io.skylite.common.StopWatch;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.lifecycle.Lifecycle;
import io.skylite.common.lifecycle.LifecycleComponent;
import io.skylite.common.network.NetworkAddress;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.threadpool.RunnableTaskExecutionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.BaseActionRegistry;
import io.skylite.core.action.bulk.BaseTransportBulkAction;
import io.skylite.core.action.search.SearchRequestStats;
import io.skylite.core.action.search.SearchTransportService;
import io.skylite.core.action.search.phase.SearchPhaseController;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.aggregations.AggregationUsageService;
import io.skylite.core.analysis.AnalysisModule;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.bootstrap.BootstrapCheck;
import io.skylite.core.bootstrap.BootstrapContext;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.ClusterInfoService;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.NodeConnectionsService;
import io.skylite.core.cluster.action.index.MappingUpdatedAction;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.cluster.remote.RemoteClusterConnectionSettings;
import io.skylite.core.cluster.routing.RerouteService;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.service.LocalNodeClusterManagerListener;
import io.skylite.core.cluster.service.NodeShutdownListener;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateApplierServiceInterface;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.cluster.state.PersistedClusterStateService;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Injector;
import io.skylite.core.common.inject.Key;
import io.skylite.core.common.inject.Module;
import io.skylite.core.common.inject.ModulesBuilder;
import io.skylite.core.common.inject.internal.SupplierMethodsModule;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.logging.HeaderWarning;
import io.skylite.core.common.logging.NodeAndClusterIdStateListener;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.transport.BoundTransportAddress;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.PageCacheRecycler;
import io.skylite.core.crypto.CryptoHandlerRegistry;
import io.skylite.core.discovery.Discovery;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.env.NodeMetadata;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.identity.IdentityService;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.remote.filecache.FileCacheFactory;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectoryFactory;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.indices.breaker.BreakerSettings;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.breaker.NoneCircuitBreakerService;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.ingest.BaseIngestService;
import io.skylite.core.monitor.FsInfo;
import io.skylite.core.monitor.FsProbe;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.node.NodeSettings;
import io.skylite.core.node.NodeValidationException;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.node.ResponseCollectorService;
import io.skylite.core.plugins.AnalysisPlugin;
import io.skylite.core.plugins.CryptoKeyProviderPlugin;
import io.skylite.core.plugins.CryptoPlugin;
import io.skylite.core.plugins.IdentityPlugin;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.plugins.MapperPlugin;
import io.skylite.core.plugins.SearchPipelinePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptEngine;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.BaseSearchService;
import io.skylite.core.search.pipeline.SearchPipelineService;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsException;
import io.skylite.core.settings.SettingsModule;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.tasks.BaseTaskResultsService;
import io.skylite.core.tasks.TaskCancellationMonitoringService;
import io.skylite.core.tasks.TaskCancellationMonitoringSettings;
import io.skylite.core.tasks.TaskCancellationService;
import io.skylite.core.tasks.TaskResourceTrackingService;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.BaseTransportService;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.TransportInterceptor;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.InternalClusterInfoService;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.metadata.SystemIndexMetadataUpgradeService;
import org.opensearch.cluster.metadata.TemplateUpgradeService;
import org.opensearch.cluster.routing.BatchedRerouteService;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.opensearch.common.settings.ConsistentSettingsService;
import org.opensearch.discovery.DiscoveryModule;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.extensions.NoopExtensionsManager;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.gateway.GatewayMetaState;
import org.opensearch.gateway.GatewayModule;
import org.opensearch.gateway.GatewayService;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.gateway.ShardsBatchGatewayAllocator;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.index.IndexModule;
import org.opensearch.index.SegmentReplicationStatsTracker;
import org.opensearch.index.recovery.RemoteStoreRestoreService;
import org.opensearch.index.remote.RemoteIndexPathUploader;
import org.opensearch.index.store.remote.filecache.FileCacheCleaner;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.indices.SystemIndexManager;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.indices.recovery.PeerRecoverySourceService;
import org.opensearch.indices.recovery.PeerRecoveryTargetService;
import org.opensearch.indices.replication.SegmentReplicationSourceFactory;
import org.opensearch.indices.replication.SegmentReplicationSourceService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.indices.store.IndicesStore;
import org.opensearch.ingest.IngestService;
import org.opensearch.monitor.MonitorService;
import org.opensearch.monitor.fs.FsHealthService;
import org.opensearch.node.NodeService;
import org.opensearch.node.ResourceUsageCollectorService;
import org.opensearch.node.resource.tracker.NodeResourceUsageTracker;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.PersistentTasksService;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlService;
import org.opensearch.ratelimitting.admissioncontrol.transport.AdmissionControlTransportInterceptor;
import org.opensearch.repositories.RepositoriesModule;
import org.opensearch.rest.RestController;
import org.opensearch.script.ScriptModule;
import org.opensearch.search.SearchModule;
import org.opensearch.search.SearchService;
import org.opensearch.search.backpressure.SearchBackpressureService;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.snapshots.InternalSnapshotsInfoService;
import org.opensearch.snapshots.RestoreService;
import org.opensearch.snapshots.SnapshotShardsService;
import org.opensearch.snapshots.SnapshotsInfoService;
import org.opensearch.tasks.TaskResultsService;
import org.opensearch.tasks.consumer.TopNSearchTasksLogger;
import org.opensearch.telemetry.TelemetryModule;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.metrics.MetricsRegistryFactory;
import org.opensearch.telemetry.metrics.NoopMetricsRegistryFactory;
import org.opensearch.telemetry.tracing.NoopTracerFactory;
import org.opensearch.telemetry.tracing.TracerFactory;
import org.opensearch.usage.UsageService;
import org.opensearch.watcher.ResourceWatcherService;

public class Node
implements Closeable,
NodeShutdownListener {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting((String)"node.portsfile", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting((String)"node.data", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    private static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting((String)"node.master", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    private static final Setting<Boolean> NODE_INGEST_SETTING = Setting.boolSetting((String)"node.ingest", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    private static final Setting<Boolean> NODE_REMOTE_CLUSTER_CLIENT = Setting.boolSetting((String)"node.remote_cluster_client", (Setting)RemoteClusterConnectionSettings.ENABLE_REMOTE_CLUSTERS, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    public static final Setting<String> BREAKER_TYPE_KEY = new Setting("indices.breaker.type", "hierarchy", s -> {
        switch (s) {
            case "hierarchy": 
            case "none": {
                return s;
            }
        }
        throw new IllegalArgumentException("indices.breaker.type must be one of [hierarchy, none] but was: " + s);
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NODE_SEARCH_CACHE_SIZE_SETTING = Setting.byteSizeSetting((String)"node.search.cache.size", (ByteSizeValue)ByteSizeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String CLIENT_TYPE = "node";
    private final JvmInfo jvmInfo;
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Node.class);
    private final Injector injector;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final ExtensionsManager extensionsManager;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;
    private final Tracer tracer;
    private final MetricsRegistry metricsRegistry;
    final NamedWriteableRegistry namedWriteableRegistry;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;
    private FileCache fileCache;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;

    public void startNodeShutdown() {
        this.stop();
    }

    public Node(Environment environment) {
        this(environment, Collections.emptyList(), true);
    }

    protected Node(Environment initialEnvironment, Collection<Class<? extends Plugin>> classpathPlugins, boolean forbidPrivateIndexSettings) {
        ArrayList<Object> resourcesToClose = new ArrayList<Object>();
        boolean success = false;
        try {
            RemoteClusterStateService remoteClusterStateService;
            RemoteIndexPathUploader remoteIndexPathUploader;
            MetricsRegistryFactory metricsRegistryFactory;
            TracerFactory tracerFactory;
            Settings tmpSettings = Settings.builder().put(initialEnvironment.settings()).put(Client.CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE).put(NodeSettings.NODE_ATTRIBUTES.getKey() + "shard_indexing_pressure_enabled", "true").build();
            this.jvmInfo = JvmInfo.jvmInfo();
            this.logger.info("version[{}], pid[{}], build[{}/{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Build.CURRENT.getQualifiedVersion(), this.jvmInfo.pid(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, System.getProperty("java.version"), Runtime.version().toString()});
            if (this.jvmInfo.getBundledJdk()) {
                this.logger.info("JVM home [{}], using bundled JDK/JRE [{}]", (Object)System.getProperty("java.home"), (Object)this.jvmInfo.getUsingBundledJdk());
            } else {
                this.logger.info("JVM home [{}]", (Object)System.getProperty("java.home"));
                this.deprecationLogger.deprecate("no-jdk", "no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release", new Object[0]);
            }
            this.logger.info("JVM arguments {}", (Object)Arrays.toString(this.jvmInfo.getInputArguments()));
            if (!Build.CURRENT.isProductionRelease()) {
                this.logger.warn("version [{}] is a pre-release version of Lucenia and is not suitable for production", (Object)Build.CURRENT.getQualifiedVersion());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)initialEnvironment.configDir(), (Object)Arrays.toString(initialEnvironment.dataFiles()), (Object)initialEnvironment.logsDir(), (Object)initialEnvironment.pluginsDir());
            }
            this.pluginsService = new PluginsService(tmpSettings, initialEnvironment.configDir(), initialEnvironment.modulesDir(), initialEnvironment.pluginsDir(), classpathPlugins);
            Settings settings = this.pluginsService.updatedSettings();
            FeatureFlags.initializeFeatureFlags((Settings)settings);
            ArrayList<IdentityPlugin> identityPlugins = new ArrayList<IdentityPlugin>();
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.identity.enabled")) {
                this.logger.info("Identity on so found plugins implementing: " + this.pluginsService.filterPlugins(IdentityPlugin.class).toString());
                identityPlugins.addAll(this.pluginsService.filterPlugins(IdentityPlugin.class));
            }
            IdentityService identityService = new IdentityService(settings, identityPlugins);
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.extensions.enabled")) {
                List<ExtensionAwarePlugin> extensionAwarePlugins = this.pluginsService.filterPlugins(ExtensionAwarePlugin.class);
                HashSet additionalSettings = new HashSet();
                for (ExtensionAwarePlugin extAwarePlugin : extensionAwarePlugins) {
                    additionalSettings.addAll(extAwarePlugin.getExtensionSettings());
                }
                this.extensionsManager = new ExtensionsManager(additionalSettings, identityService);
            } else {
                this.extensionsManager = new NoopExtensionsManager();
            }
            Set additionalRoles = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getRoles).flatMap(Collection::stream).collect(Collectors.toSet());
            DiscoveryNode.setAdditionalRoles(additionalRoles);
            DiscoveryNode.setDeprecatedMasterRole();
            this.environment = new Environment(settings, initialEnvironment.configDir(), ((Boolean)NodeSettings.NODE_LOCAL_STORAGE_SETTING.get(settings)).booleanValue());
            Environment.assertEquivalent((Environment)initialEnvironment, (Environment)this.environment);
            this.nodeEnvironment = new NodeEnvironment(tmpSettings, this.environment);
            this.logger.info("node name [{}], node ID [{}], cluster name [{}], roles {}", CommonSettings.NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings)).value(), (Object)DiscoveryNode.getRolesFromSettings((Settings)settings).stream().map(NodeRole::roleName).collect(Collectors.toCollection(LinkedHashSet::new)));
            resourcesToClose.add(this.nodeEnvironment);
            List<ExecutorBuilder<?>> executorBuilders = this.pluginsService.getExecutorBuilders(settings);
            this.runnableTaskListener = new AtomicReference();
            ThreadPool threadPool = new ThreadPool(settings, this.runnableTaskListener, executorBuilders.toArray(new ExecutorBuilder[0]));
            SetOnce repositoriesServiceReference = new SetOnce();
            RemoteStoreNodeService remoteStoreNodeService = new RemoteStoreNodeService(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool);
            this.localNodeFactory = new LocalNodeFactory(settings, this.nodeEnvironment.nodeId(), remoteStoreNodeService);
            resourcesToClose.add(() -> ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS));
            ResourceWatcherService resourceWatcherService = new ResourceWatcherService(settings, threadPool);
            resourcesToClose.add(resourceWatcherService);
            HeaderWarning.setThreadContext((ThreadContext)threadPool.getThreadContext());
            resourcesToClose.add(() -> HeaderWarning.removeThreadContext((ThreadContext)threadPool.getThreadContext()));
            ArrayList additionalSettings = new ArrayList();
            additionalSettings.add(NODE_DATA_SETTING);
            additionalSettings.add(NODE_INGEST_SETTING);
            additionalSettings.add(NODE_MASTER_SETTING);
            additionalSettings.add(NODE_REMOTE_CLUSTER_CLIENT);
            additionalSettings.addAll(this.pluginsService.getPluginSettings());
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>(this.pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(settings, threadPool);
            ScriptModule scriptModule = new ScriptModule(settings, this.pluginsService.filterPlugins(ScriptPlugin.class));
            ScriptService scriptService = this.newScriptService(settings, scriptModule.engines, scriptModule.contexts);
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            Set settingsUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getSettingUpgraders).flatMap(Collection::stream).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, additionalSettingsFilter, settingsUpgraders);
            scriptModule.registerClusterSettingsListeners(scriptService, settingsModule.getClusterSettings());
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            ClusterService clusterService = new ClusterService(settings, settingsModule.getClusterSettings(), threadPool);
            clusterService.addStateApplier((ClusterStateApplier)scriptService);
            clusterService.addNodeShutdownListener((NodeShutdownListener)this);
            resourcesToClose.add(clusterService);
            Set consistentSettings = settingsModule.getConsistentSettings();
            if (!consistentSettings.isEmpty()) {
                clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)new ConsistentSettingsService(settings, clusterService, consistentSettings).newHashPublisher());
            }
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.telemetry.enabled")) {
                TelemetrySettings telemetrySettings = new TelemetrySettings(settings, clusterService.getClusterSettings());
                if (telemetrySettings.isTracingFeatureEnabled() || telemetrySettings.isMetricsFeatureEnabled()) {
                    List<TelemetryPlugin> telemetryPlugins = this.pluginsService.filterPlugins(TelemetryPlugin.class);
                    for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
                        if (!(telemetryPlugin instanceof TelemetryAwarePlugin)) continue;
                        throw new IllegalStateException("TelemetryPlugin [" + telemetryPlugin.getClass().getName() + "] cannot also implement TelemetryAwarePlugin");
                    }
                    TelemetryModule telemetryModule = new TelemetryModule(telemetryPlugins, telemetrySettings);
                    tracerFactory = telemetrySettings.isTracingFeatureEnabled() ? new TracerFactory(telemetrySettings, telemetryModule.getTelemetry(), threadPool.getThreadContext()) : new NoopTracerFactory();
                    metricsRegistryFactory = telemetrySettings.isMetricsFeatureEnabled() ? new MetricsRegistryFactory(telemetrySettings, telemetryModule.getTelemetry()) : new NoopMetricsRegistryFactory();
                } else {
                    tracerFactory = new NoopTracerFactory();
                    metricsRegistryFactory = new NoopMetricsRegistryFactory();
                }
            } else {
                tracerFactory = new NoopTracerFactory();
                metricsRegistryFactory = new NoopMetricsRegistryFactory();
            }
            this.tracer = ((TracerFactory)tracerFactory).getTracer();
            this.metricsRegistry = ((MetricsRegistryFactory)metricsRegistryFactory).getMetricsRegistry();
            resourcesToClose.add(() -> this.tracer.close());
            resourcesToClose.add(() -> this.metricsRegistry.close());
            IngestService ingestService = new IngestService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), this.pluginsService.filterPlugins(IngestPlugin.class), (ReleasableSkyliteClient)this.client);
            ClusterInfoService clusterInfoService = this.newClusterInfoService(settings, clusterService, threadPool, this.client);
            UsageService usageService = new UsageService();
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(new Module[]{pluginModule});
            }
            FsHealthService fsHealthService = new FsHealthService(settings, clusterService.getClusterSettings(), threadPool, this.nodeEnvironment);
            SetOnce rerouteServiceReference = new SetOnce();
            InternalSnapshotsInfoService snapshotsInfoService = new InternalSnapshotsInfoService(settings, clusterService, () -> ((SetOnce)repositoriesServiceReference).get(), () -> ((SetOnce)rerouteServiceReference).get());
            ClusterModule clusterModule = new ClusterModule(settings, clusterService, clusterPlugins, clusterInfoService, snapshotsInfoService, threadPool.getThreadContext());
            modules.add(new Module[]{clusterModule});
            modules.add(new Module[]{SupplierMethodsModule.forModule((Module)clusterModule)});
            IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class));
            modules.add(new Module[]{indicesModule});
            SearchModule searchModule = new SearchModule(settings, this.pluginsService.filterPlugins(SearchPlugin.class));
            List<BreakerSettings> pluginCircuitBreakers = this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).stream().map(plugin -> plugin.getCircuitBreaker(settings)).collect(Collectors.toList());
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), pluginCircuitBreakers, settingsModule.getClusterSettings());
            this.initializeFileCache(settings, circuitBreakerService.getBreaker("request"));
            FileCacheCleaner fileCacheCleaner = new FileCacheCleaner(this.nodeEnvironment, this.fileCache);
            MonitorService monitorService = new MonitorService(settings, this.nodeEnvironment, threadPool, this.fileCache);
            clusterService.setJvmInfo(this.jvmInfo);
            this.pluginsService.filterPlugins(CircuitBreakerPlugin.class).forEach(plugin -> {
                CircuitBreaker breaker = circuitBreakerService.getBreaker(plugin.getCircuitBreaker(settings).getName());
                plugin.setCircuitBreaker(breaker);
            });
            resourcesToClose.add(circuitBreakerService);
            modules.add(new Module[]{new GatewayModule()});
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            modules.add(new Module[]{settingsModule});
            List namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), indicesModule.getNamedWriteables().stream(), searchModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList());
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), searchModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, xContentRegistry);
            PersistedClusterStateService lucenePersistedStateFactory = new PersistedClusterStateService(this.nodeEnvironment.nodeDataPaths(), this.nodeEnvironment.nodeId(), xContentRegistry, bigArrays, clusterService.getClusterSettings(), () -> ((ThreadPool)threadPool).relativeTimeInMillis());
            if (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled((Settings)settings)) {
                remoteIndexPathUploader = new RemoteIndexPathUploader(threadPool, settings, () -> ((SetOnce)repositoriesServiceReference).get(), clusterService.getClusterSettings());
                remoteClusterStateService = new RemoteClusterStateService(this.nodeEnvironment.nodeId(), () -> ((SetOnce)repositoriesServiceReference).get(), settings, clusterService.getClusterSettings(), () -> ((ThreadPool)threadPool).preciseRelativeTimeInNanos(), threadPool, List.of(remoteIndexPathUploader));
            } else {
                remoteClusterStateService = null;
                remoteIndexPathUploader = null;
            }
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            Collection engineFactoryProviders = enginePlugins.stream().map(plugin -> plugin::getEngineFactory).collect(Collectors.toList());
            Map<String, IndexStorePlugin.DirectoryFactory> builtInDirectoryFactories = IndexModule.createBuiltInDirectoryFactories(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool, this.fileCache);
            HashMap<String, IndexStorePlugin.DirectoryFactory> directoryFactories = new HashMap<String, IndexStorePlugin.DirectoryFactory>();
            this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((k, v) -> {
                if (builtInDirectoryFactories.containsKey(k)) {
                    throw new IllegalStateException("registered index store type [" + k + "] conflicts with a built-in type");
                }
                directoryFactories.put((String)k, (IndexStorePlugin.DirectoryFactory)v);
            });
            directoryFactories.putAll(builtInDirectoryFactories);
            Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getRecoveryStateFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Collection> systemIndexDescriptorMap = Collections.unmodifiableMap(this.pluginsService.filterPlugins(SystemIndexPlugin.class).stream().collect(Collectors.toMap(plugin -> plugin.getClass().getSimpleName(), plugin -> plugin.getSystemIndexDescriptors(settings))));
            SystemIndices systemIndices = new SystemIndices(systemIndexDescriptorMap);
            SystemIndexManager systemIndexManager = new SystemIndexManager(systemIndices, (Client)this.client);
            clusterService.addListener((ClusterStateListener)systemIndexManager);
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            rerouteServiceReference.set((Object)rerouteService);
            clusterService.setRerouteService((RerouteService)rerouteService);
            RecoverySettings recoverySettings = new RecoverySettings(settings, settingsModule.getClusterSettings());
            RemoteStoreSettings remoteStoreSettings = new RemoteStoreSettings(settings, settingsModule.getClusterSettings());
            RemoteSegmentStoreDirectoryFactory remoteDirectoryFactory = new RemoteSegmentStoreDirectoryFactory(() -> ((SetOnce)repositoriesServiceReference).get(), threadPool);
            SearchRequestStats searchRequestStats = new SearchRequestStats();
            this.remoteStoreStatsTrackerFactory = new RemoteStoreStatsTrackerFactory(clusterService.getClusterSettings(), settings);
            IndicesService indicesService = new IndicesService(settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), clusterModule.getIndexNameExpressionResolver(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, scriptService, clusterService, (Client)this.client, metaStateService, engineFactoryProviders, Map.copyOf(directoryFactories), searchModule.getValuesSourceRegistry(), recoveryStateFactories, (IndexStorePlugin.DirectoryFactory)remoteDirectoryFactory, () -> ((SetOnce)repositoriesServiceReference).get(), fileCacheCleaner, searchRequestStats, this.remoteStoreStatsTrackerFactory, recoverySettings, remoteStoreSettings);
            AliasValidator aliasValidator = new AliasValidator();
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(settings, clusterService, systemIndices);
            AwarenessReplicaBalance awarenessReplicaBalance = new AwarenessReplicaBalance(settings, clusterService.getClusterSettings());
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(settings, clusterService, indicesService, clusterModule.getAllocationService(), aliasValidator, shardLimitValidator, this.environment, settingsModule.getIndexScopedSettings(), threadPool, xContentRegistry, systemIndices, forbidPrivateIndexSettings, awarenessReplicaBalance, remoteStoreSettings, () -> ((SetOnce)repositoriesServiceReference).get());
            this.pluginsService.filterPlugins(Plugin.class).forEach(p -> p.getAdditionalIndexSettingProviders().forEach(metadataCreateIndexService::addAdditionalIndexSettingProvider));
            MetadataCreateDataStreamService metadataCreateDataStreamService = new MetadataCreateDataStreamService(threadPool, clusterService, metadataCreateIndexService);
            Collection pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents((Client)this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get()).stream()).collect(Collectors.toList());
            Collection telemetryAwarePluginComponents = this.pluginsService.filterPlugins(TelemetryAwarePlugin.class).stream().flatMap(p -> p.createComponents((Client)this.client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, this.environment, this.nodeEnvironment, namedWriteableRegistry, clusterModule.getIndexNameExpressionResolver(), () -> ((SetOnce)repositoriesServiceReference).get(), this.tracer, this.metricsRegistry).stream()).collect(Collectors.toList());
            pluginComponents.addAll(telemetryAwarePluginComponents);
            ActionModule actionModule = new ActionModule(settings, clusterModule.getIndexNameExpressionResolver(), settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, this.pluginsService.filterPlugins(ActionPlugin.class), this.client, circuitBreakerService, usageService, systemIndices, identityService, this.extensionsManager);
            modules.add(new Module[]{actionModule});
            RestController restController = actionModule.getRestController();
            AdmissionControlService admissionControlService = new AdmissionControlService(settings, clusterService.getClusterSettings(), threadPool);
            AdmissionControlTransportInterceptor admissionControlTransportInterceptor = new AdmissionControlTransportInterceptor(admissionControlService);
            Collection secureSettingsFactories = this.pluginsService.filterPlugins(Plugin.class).stream().map(p -> p.getSecureSettingFactory(settings)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List<TransportInterceptor> transportInterceptors = List.of(admissionControlTransportInterceptor);
            NetworkModule networkModule = new NetworkModule(settings, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, restController, clusterService.getClusterSettings(), this.tracer, transportInterceptors, secureSettingsFactories);
            Collection indexTemplateMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getIndexTemplateMetadataUpgrader).collect(Collectors.toList());
            MetadataUpgrader metadataUpgrader = new MetadataUpgrader(indexTemplateMetadataUpgraders);
            MetadataIndexUpgradeService metadataIndexUpgradeService = new MetadataIndexUpgradeService(settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), systemIndices, scriptService);
            if (DiscoveryNode.isClusterManagerNode((Settings)settings)) {
                clusterService.addListener((ClusterStateListener)new SystemIndexMetadataUpgradeService(systemIndices, clusterService));
            }
            new TemplateUpgradeService((Client)this.client, clusterService, threadPool, indexTemplateMetadataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            Set<String> taskHeaders = Stream.concat(this.pluginsService.filterPlugins(ActionPlugin.class).stream().flatMap(p -> p.getTaskHeaders().stream()), Stream.of("X-Opaque-Id")).collect(Collectors.toSet());
            TransportService transportService = this.newTransportService(settings, transport, threadPool, networkModule.getTransportInterceptor(), this.localNodeFactory, settingsModule.getClusterSettings(), taskHeaders, this.tracer);
            TopNSearchTasksLogger taskConsumer = new TopNSearchTasksLogger(settings, settingsModule.getClusterSettings());
            transportService.getTaskManager().registerTaskResourceConsumer((Consumer)taskConsumer);
            this.extensionsManager.initializeServicesAndRestHandler(actionModule, settingsModule, transportService, clusterService, this.environment.settings(), this.client, identityService);
            PersistedStateRegistry persistedStateRegistry = new PersistedStateRegistry();
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            ResponseCollectorService responseCollectorService = clusterService.addNewResponseCollectorServiceListener();
            SearchTransportService searchTransportService = new SearchTransportService(transportService, SearchExecutionStatsCollector.makeWrapper(responseCollectorService));
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkModule);
            IndexingPressureService indexingPressureService = new IndexingPressureService(settings, clusterService.getClusterSettings());
            clusterService.setIndexingPressureService(indexingPressureService);
            TaskResourceTrackingService taskResourceTrackingService = new TaskResourceTrackingService(settings, clusterService.getClusterSettings(), threadPool);
            SearchBackpressureSettings searchBackpressureSettings = new SearchBackpressureSettings(settings, clusterService.getClusterSettings());
            SearchBackpressureService searchBackpressureService = new SearchBackpressureService(searchBackpressureSettings, taskResourceTrackingService, threadPool, transportService.getTaskManager());
            SegmentReplicationStatsTracker segmentReplicationStatsTracker = new SegmentReplicationStatsTracker(indicesService);
            RepositoriesModule repositoriesModule = new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), transportService, clusterService, threadPool, xContentRegistry, recoverySettings);
            CryptoHandlerRegistry.initRegistry(this.pluginsService.filterPlugins(CryptoPlugin.class), this.pluginsService.filterPlugins(CryptoKeyProviderPlugin.class), (Settings)settings);
            RepositoriesService repositoryService = repositoriesModule.getRepositoryService();
            repositoriesServiceReference.set((Object)repositoryService);
            SnapshotsService snapshotsService = new SnapshotsService(settings, clusterService, clusterModule.getIndexNameExpressionResolver(), repositoryService, transportService, actionModule.getActionFilters());
            SnapshotShardsService snapshotShardsService = new SnapshotShardsService(settings, clusterService, repositoryService, transportService, indicesService);
            TransportNodesSnapshotsStatus nodesSnapshotsStatus = new TransportNodesSnapshotsStatus(threadPool, clusterService, transportService, snapshotShardsService, actionModule.getActionFilters());
            RestoreService restoreService = new RestoreService(clusterService, repositoryService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, shardLimitValidator, indicesService, () -> ((ClusterInfoService)clusterInfoService).getClusterInfo());
            RemoteStoreRestoreService remoteStoreRestoreService = new RemoteStoreRestoreService(clusterService, clusterModule.getAllocationService(), metadataCreateIndexService, metadataIndexUpgradeService, shardLimitValidator, remoteClusterStateService);
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(settings, () -> ((ClusterService)clusterService).state(), clusterService.getClusterSettings(), (Client)this.client, () -> ((ThreadPool)threadPool).relativeTimeInMillis(), rerouteService);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            DiscoveryModule discoveryModule = new DiscoveryModule(settings, threadPool, transportService, namedWriteableRegistry, networkService, clusterService.getClusterManagerService(), (ClusterStateApplierServiceInterface)clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), this.environment.configDir(), gatewayMetaState, rerouteService, fsHealthService, persistedStateRegistry, remoteStoreNodeService);
            SearchPipelineService searchPipelineService = new SearchPipelineService(clusterService, threadPool, this.environment, scriptService, analysisModule.getAnalysisRegistry(), xContentRegistry, namedWriteableRegistry, this.pluginsService.filterPlugins(SearchPipelinePlugin.class), (Client)this.client);
            TaskCancellationMonitoringSettings taskCancellationMonitoringSettings = new TaskCancellationMonitoringSettings(settings, clusterService.getClusterSettings());
            TaskCancellationMonitoringService taskCancellationMonitoringService = new TaskCancellationMonitoringService(threadPool, transportService.getTaskManager(), taskCancellationMonitoringSettings);
            NodeResourceUsageTracker nodeResourceUsageTracker = new NodeResourceUsageTracker(threadPool, settings, clusterService.getClusterSettings());
            ResourceUsageCollectorService resourceUsageCollectorService = new ResourceUsageCollectorService(nodeResourceUsageTracker, clusterService, threadPool);
            this.nodeService = new NodeService(settings, threadPool, monitorService, discoveryModule.getDiscovery(), transportService, indicesService, this.pluginsService, circuitBreakerService, scriptService, httpServerTransport, ingestService, clusterService, settingsModule.getSettingsFilter(), responseCollectorService, searchTransportService, indexingPressureService, searchModule.getValuesSourceRegistry().getUsageService(), searchBackpressureService, searchPipelineService, this.fileCache, taskCancellationMonitoringService, resourceUsageCollectorService, segmentReplicationStatsTracker, repositoryService);
            SearchService searchService = this.newSearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, searchModule.getQueryPhase(), searchModule.getFetchPhase(), responseCollectorService, circuitBreakerService, searchModule.getIndexSearcherExecutor(threadPool));
            List<PersistentTasksExecutor<?>> tasksExecutors = this.pluginsService.filterPlugins(PersistentTaskPlugin.class).stream().map(p -> p.getPersistentTasksExecutor(clusterService, threadPool, (Client)this.client, settingsModule, clusterModule.getIndexNameExpressionResolver())).flatMap(Collection::stream).collect(Collectors.toList());
            PersistentTasksExecutorRegistry registry = new PersistentTasksExecutorRegistry(tasksExecutors);
            PersistentTasksClusterService persistentTasksClusterService = new PersistentTasksClusterService(settings, registry, clusterService, threadPool);
            resourcesToClose.add(persistentTasksClusterService);
            PersistentTasksService persistentTasksService = new PersistentTasksService(clusterService, threadPool, (Client)this.client);
            modules.add(new Module[]{b -> {
                b.bind(Node.class).toInstance((Object)this);
                b.bind(NodeService.class).toInstance((Object)this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance((Object)xContentRegistry);
                b.bind(PluginsService.class).toInstance((Object)this.pluginsService);
                b.bind(Client.class).toInstance((Object)this.client);
                b.bind(NodeClient.class).toInstance((Object)this.client);
                b.bind(Environment.class).toInstance((Object)this.environment);
                b.bind(ExtensionsManager.class).toInstance((Object)this.extensionsManager);
                b.bind(ThreadPool.class).toInstance((Object)threadPool);
                b.bind(NodeEnvironment.class).toInstance((Object)this.nodeEnvironment);
                b.bind(ResourceWatcherService.class).toInstance((Object)resourceWatcherService);
                b.bind(CircuitBreakerService.class).toInstance((Object)circuitBreakerService);
                b.bind(BigArrays.class).toInstance((Object)bigArrays);
                b.bind(PageCacheRecycler.class).toInstance((Object)pageCacheRecycler);
                b.bind(ScriptService.class).toInstance((Object)scriptService);
                b.bind(AnalysisRegistry.class).toInstance((Object)analysisModule.getAnalysisRegistry());
                b.bind(IngestService.class).toInstance((Object)ingestService);
                b.bind(BaseIngestService.class).toInstance((Object)ingestService);
                b.bind(SearchPipelineService.class).toInstance((Object)searchPipelineService);
                b.bind(IndexingPressureService.class).toInstance((Object)indexingPressureService);
                b.bind(TaskResourceTrackingService.class).toInstance((Object)taskResourceTrackingService);
                b.bind(SearchBackpressureService.class).toInstance((Object)searchBackpressureService);
                b.bind(AdmissionControlService.class).toInstance((Object)admissionControlService);
                b.bind(UsageService.class).toInstance((Object)usageService);
                b.bind(AggregationUsageService.class).toInstance((Object)searchModule.getValuesSourceRegistry().getUsageService());
                b.bind(NamedWriteableRegistry.class).toInstance((Object)namedWriteableRegistry);
                b.bind(MetadataUpgrader.class).toInstance((Object)metadataUpgrader);
                b.bind(MetaStateService.class).toInstance((Object)metaStateService);
                b.bind(PersistedClusterStateService.class).toInstance((Object)lucenePersistedStateFactory);
                b.bind(IndicesService.class).toInstance((Object)indicesService);
                b.bind(TransportReplicationAction.IndexServiceProvider.class).toSupplier(() -> indicesService::indexServiceSafe);
                b.bind(BaseTransportBulkAction.class).to(TransportBulkAction.class);
                b.bind(RemoteStoreStatsTrackerFactory.class).toInstance((Object)this.remoteStoreStatsTrackerFactory);
                b.bind(AliasValidator.class).toInstance((Object)aliasValidator);
                b.bind(MetadataCreateIndexService.class).toInstance((Object)metadataCreateIndexService);
                b.bind(AwarenessReplicaBalance.class).toInstance((Object)awarenessReplicaBalance);
                b.bind(MetadataCreateDataStreamService.class).toInstance((Object)metadataCreateDataStreamService);
                b.bind(SearchService.class).toInstance((Object)searchService);
                b.bind(BaseSearchService.class).toInstance((Object)searchService);
                b.bind(SearchTransportService.class).toInstance((Object)searchTransportService);
                b.bind(SearchPhaseController.class).toInstance((Object)new SearchPhaseController(namedWriteableRegistry, searchService::aggReduceContextBuilder));
                b.bind(Transport.class).toInstance((Object)transport);
                b.bind(BaseTransportService.class).to(TransportService.class);
                b.bind(TransportService.class).toInstance((Object)transportService);
                b.bind(NetworkService.class).toInstance((Object)networkService);
                b.bind(UpdateHelper.class).toInstance((Object)new UpdateHelper(scriptService));
                b.bind(MetadataIndexUpgradeService.class).toInstance((Object)metadataIndexUpgradeService);
                b.bind(ClusterInfoService.class).toInstance((Object)clusterInfoService);
                b.bind(SnapshotsInfoService.class).toInstance((Object)snapshotsInfoService);
                b.bind(GatewayMetaState.class).toInstance((Object)gatewayMetaState);
                b.bind(Discovery.class).toInstance((Object)discoveryModule.getDiscovery());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                b.bind(PeerRecoverySourceService.class).toInstance((Object)new PeerRecoverySourceService(transportService, indicesService, recoverySettings));
                b.bind(PeerRecoveryTargetService.class).toInstance((Object)new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService));
                b.bind(SegmentReplicationTargetService.class).toInstance((Object)new SegmentReplicationTargetService(threadPool, recoverySettings, transportService, new SegmentReplicationSourceFactory(transportService, recoverySettings, clusterService), indicesService, clusterService));
                b.bind(SegmentReplicationSourceService.class).toInstance((Object)new SegmentReplicationSourceService(indicesService, transportService, recoverySettings));
                b.bind(HttpServerTransport.class).toInstance((Object)httpServerTransport);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
                b.bind(PersistentTasksService.class).toInstance((Object)persistentTasksService);
                b.bind(PersistentTasksClusterService.class).toInstance((Object)persistentTasksClusterService);
                b.bind(PersistentTasksExecutorRegistry.class).toInstance((Object)registry);
                b.bind(RepositoriesService.class).toInstance((Object)repositoryService);
                b.bind(SnapshotsService.class).toInstance((Object)snapshotsService);
                b.bind(SnapshotShardsService.class).toInstance((Object)snapshotShardsService);
                b.bind(TransportNodesSnapshotsStatus.class).toInstance((Object)nodesSnapshotsStatus);
                b.bind(RestoreService.class).toInstance((Object)restoreService);
                b.bind(RemoteStoreRestoreService.class).toInstance((Object)remoteStoreRestoreService);
                b.bind(RerouteService.class).toInstance((Object)rerouteService);
                b.bind(ShardLimitValidator.class).toInstance((Object)shardLimitValidator);
                b.bind(FsHealthService.class).toInstance((Object)fsHealthService);
                b.bind(NodeResourceUsageTracker.class).toInstance((Object)nodeResourceUsageTracker);
                b.bind(ResourceUsageCollectorService.class).toInstance((Object)resourceUsageCollectorService);
                b.bind(SystemIndices.class).toInstance((Object)systemIndices);
                b.bind(IdentityService.class).toInstance((Object)identityService);
                b.bind(Tracer.class).toInstance((Object)this.tracer);
                b.bind(SearchRequestStats.class).toInstance((Object)searchRequestStats);
                b.bind(MetricsRegistry.class).toInstance((Object)this.metricsRegistry);
                b.bind(RemoteClusterStateService.class).toSupplier(() -> remoteClusterStateService);
                b.bind(RemoteIndexPathUploader.class).toSupplier(() -> remoteIndexPathUploader);
                b.bind(PersistedStateRegistry.class).toInstance((Object)persistedStateRegistry);
                b.bind(SegmentReplicationStatsTracker.class).toInstance((Object)segmentReplicationStatsTracker);
            }});
            this.injector = modules.createInjector();
            clusterModule.setExistingShardsAllocators((GatewayAllocator)this.injector.getInstance(GatewayAllocator.class), (ShardsBatchGatewayAllocator)this.injector.getInstance(ShardsBatchGatewayAllocator.class));
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(arg_0 -> ((Injector)this.injector).getInstance(arg_0)).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add((Closeable)this.injector.getInstance(PeerRecoverySourceService.class));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            ActionModule.DynamicActionRegistry dynamicActionRegistry = actionModule.getDynamicActionRegistry();
            dynamicActionRegistry.registerUnmodifiableActionMap((Map)this.injector.getInstance((Key)new Key<Map<ActionType, TransportAction>>(this){}));
            this.client.initialize((BaseActionRegistry)dynamicActionRegistry, () -> clusterService.localNode().getId(), transportService.getRemoteClusterService(), namedWriteableRegistry);
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.logger.debug("initializing HTTP handlers ...");
            actionModule.initRestHandlers(() -> clusterService.state().nodes());
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new SkyliteException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        return new TransportService(settings, transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, tracer);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.environment.settings();
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        GatewayMetaState gatewayMetaState;
        TransportService transportService;
        Discovery discovery;
        ClusterService clusterService;
        block19: {
            RemoteIndexPathUploader remoteIndexPathUploader;
            if (!this.lifecycle.moveToStarted()) {
                return this;
            }
            this.logger.info("starting ...");
            this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
            ((MappingUpdatedAction)this.injector.getInstance(MappingUpdatedAction.class)).setClient((Client)this.client);
            ((IndicesService)this.injector.getInstance(IndicesService.class)).start();
            ((IndicesClusterStateService)((Object)this.injector.getInstance(IndicesClusterStateService.class))).start();
            ((SnapshotsService)this.injector.getInstance(SnapshotsService.class)).start();
            ((SnapshotShardsService)((Object)this.injector.getInstance(SnapshotShardsService.class))).start();
            ((RepositoriesService)this.injector.getInstance(RepositoriesService.class)).start();
            ((SearchService)((Object)this.injector.getInstance(SearchService.class))).start();
            ((FsHealthService)this.injector.getInstance(FsHealthService.class)).start();
            ((NodeResourceUsageTracker)((Object)this.injector.getInstance(NodeResourceUsageTracker.class))).start();
            ((ResourceUsageCollectorService)((Object)this.injector.getInstance(ResourceUsageCollectorService.class))).start();
            this.nodeService.getMonitorService().start();
            this.nodeService.getSearchBackpressureService().start();
            this.nodeService.getTaskCancellationMonitoringService().start();
            clusterService = (ClusterService)this.injector.getInstance(ClusterService.class);
            NodeConnectionsService nodeConnectionsService = (NodeConnectionsService)this.injector.getInstance(NodeConnectionsService.class);
            nodeConnectionsService.start();
            clusterService.setNodeConnectionsService(nodeConnectionsService);
            ((GatewayService)((Object)this.injector.getInstance(GatewayService.class))).start();
            discovery = (Discovery)this.injector.getInstance(Discovery.class);
            clusterService.getClusterManagerService().setClusterStatePublisher((arg_0, arg_1, arg_2) -> ((Discovery)discovery).publish(arg_0, arg_1, arg_2));
            transportService = (TransportService)this.injector.getInstance(TransportService.class);
            transportService.getTaskManager().setTaskResultsService((BaseTaskResultsService)this.injector.getInstance(TaskResultsService.class));
            transportService.getTaskManager().setTaskCancellationService(new TaskCancellationService((BaseTransportService)transportService));
            TaskResourceTrackingService taskResourceTrackingService = (TaskResourceTrackingService)this.injector.getInstance(TaskResourceTrackingService.class);
            transportService.getTaskManager().setTaskResourceTrackingService(taskResourceTrackingService);
            this.runnableTaskListener.set((RunnableTaskExecutionListener)taskResourceTrackingService);
            transportService.start();
            assert (this.localNodeFactory.getNode() != null);
            assert (transportService.getLocalNode().equals((Object)this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
            ((PeerRecoverySourceService)((Object)this.injector.getInstance(PeerRecoverySourceService.class))).start();
            ((SegmentReplicationTargetService)((Object)this.injector.getInstance(SegmentReplicationTargetService.class))).start();
            ((SegmentReplicationSourceService)((Object)this.injector.getInstance(SegmentReplicationSourceService.class))).start();
            RemoteClusterStateService remoteClusterStateService = (RemoteClusterStateService)this.injector.getInstance(RemoteClusterStateService.class);
            if (remoteClusterStateService != null) {
                remoteClusterStateService.start();
            }
            if ((remoteIndexPathUploader = (RemoteIndexPathUploader)((Object)this.injector.getInstance(RemoteIndexPathUploader.class))) != null) {
                remoteIndexPathUploader.start();
            }
            gatewayMetaState = (GatewayMetaState)this.injector.getInstance(GatewayMetaState.class);
            gatewayMetaState.start(this.settings(), transportService, clusterService, (MetaStateService)this.injector.getInstance(MetaStateService.class), (MetadataIndexUpgradeService)this.injector.getInstance(MetadataIndexUpgradeService.class), (MetadataUpgrader)this.injector.getInstance(MetadataUpgrader.class), (PersistedClusterStateService)this.injector.getInstance(PersistedClusterStateService.class), (RemoteClusterStateService)this.injector.getInstance(RemoteClusterStateService.class), (PersistedStateRegistry)this.injector.getInstance(PersistedStateRegistry.class), (RemoteStoreRestoreService)this.injector.getInstance(RemoteStoreRestoreService.class));
            if (Assertions.ENABLED) {
                try {
                    assert (((Manifest)((MetaStateService)this.injector.getInstance(MetaStateService.class)).loadFullState().v1()).isEmpty());
                    NodeMetadata nodeMetadata = (NodeMetadata)NodeMetadata.FORMAT.loadLatestState(this.logger, NamedXContentRegistry.EMPTY, this.nodeEnvironment.nodeDataPaths());
                    assert (nodeMetadata != null);
                    assert (nodeMetadata.nodeVersion().equals((Object)Version.CURRENT));
                    assert (nodeMetadata.nodeId().equals(this.localNodeFactory.getNode().getId()));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)e);
                }
            }
        }
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(new BootstrapContext(this.environment, onDiskMetadata), transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).collect(Collectors.toList()));
        clusterService.addStateApplier((ClusterStateApplier)transportService.getTaskManager());
        discovery.start();
        clusterService.start();
        assert (clusterService.localNode().equals((Object)this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        discovery.startInitialJoin();
        final TimeValue initialStateTimeout = (TimeValue)DiscoverySettings.INITIAL_STATE_TIMEOUT_SETTING.get(this.settings());
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = (ThreadPool)this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger, thread.getThreadContext());
            if (clusterState.nodes().getClusterManagerNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    public void onTimeout(TimeValue timeout) {
                        Node.this.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getClusterManagerNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new SkyliteTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        ((HttpServerTransport)this.injector.getInstance(HttpServerTransport.class)).start();
        if (((Boolean)WRITE_PORTS_FILE_SETTING.get(this.settings())).booleanValue()) {
            TransportService transport = (TransportService)this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = (HttpServerTransport)this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
        }
        this.logger.info("started");
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(plugin -> plugin.onNodeStarted(clusterService.localNode()));
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId((ClusterService)clusterService, (ThreadContext)((ThreadPool)this.injector.getInstance(ThreadPool.class)).getThreadContext());
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        ((ResourceWatcherService)this.injector.getInstance(ResourceWatcherService.class)).close();
        ((HttpServerTransport)this.injector.getInstance(HttpServerTransport.class)).stop();
        ((SnapshotsService)this.injector.getInstance(SnapshotsService.class)).stop();
        ((SnapshotShardsService)((Object)this.injector.getInstance(SnapshotShardsService.class))).stop();
        ((RepositoriesService)this.injector.getInstance(RepositoriesService.class)).stop();
        ((IndicesClusterStateService)((Object)this.injector.getInstance(IndicesClusterStateService.class))).stop();
        ((Discovery)this.injector.getInstance(Discovery.class)).stop();
        ((ClusterService)this.injector.getInstance(ClusterService.class)).stop();
        ((NodeConnectionsService)this.injector.getInstance(NodeConnectionsService.class)).stop();
        ((FsHealthService)this.injector.getInstance(FsHealthService.class)).stop();
        ((NodeResourceUsageTracker)((Object)this.injector.getInstance(NodeResourceUsageTracker.class))).stop();
        ((ResourceUsageCollectorService)((Object)this.injector.getInstance(ResourceUsageCollectorService.class))).stop();
        this.nodeService.getMonitorService().stop();
        this.nodeService.getSearchBackpressureService().stop();
        ((GatewayService)((Object)this.injector.getInstance(GatewayService.class))).stop();
        ((SearchService)((Object)this.injector.getInstance(SearchService.class))).stop();
        ((TransportService)this.injector.getInstance(TransportService.class)).stop();
        this.nodeService.getTaskCancellationMonitoringService().stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        ((IndicesService)this.injector.getInstance(IndicesService.class)).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Object> toClose = new ArrayList<Object>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add((Closeable)this.injector.getInstance(HttpServerTransport.class));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add((Closeable)this.injector.getInstance(SnapshotsService.class));
        toClose.add((Closeable)this.injector.getInstance(SnapshotShardsService.class));
        toClose.add((Closeable)this.injector.getInstance(RepositoriesService.class));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close((Releasable)((Releasable)this.injector.getInstance(Client.class)));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add((Closeable)this.injector.getInstance(IndicesClusterStateService.class));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add((Closeable)this.injector.getInstance(IndicesService.class));
        toClose.add((Closeable)this.injector.getInstance(IndicesStore.class));
        toClose.add((Closeable)this.injector.getInstance(PeerRecoverySourceService.class));
        toClose.add((Closeable)this.injector.getInstance(SegmentReplicationSourceService.class));
        toClose.add((Closeable)this.injector.getInstance(SegmentReplicationTargetService.class));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add((Closeable)this.injector.getInstance(ClusterService.class));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add((Closeable)this.injector.getInstance(NodeConnectionsService.class));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add((Closeable)this.injector.getInstance(Discovery.class));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add((Object)this.nodeService.getMonitorService());
        toClose.add((Object)this.nodeService.getSearchBackpressureService());
        toClose.add(() -> stopWatch.stop().start("fsHealth"));
        toClose.add((Closeable)this.injector.getInstance(FsHealthService.class));
        toClose.add(() -> stopWatch.stop().start("resource_usage_tracker"));
        toClose.add((Closeable)this.injector.getInstance(NodeResourceUsageTracker.class));
        toClose.add(() -> stopWatch.stop().start("resource_usage_collector"));
        toClose.add((Closeable)this.injector.getInstance(ResourceUsageCollectorService.class));
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add((Closeable)this.injector.getInstance(GatewayService.class));
        toClose.add(() -> stopWatch.stop().start("search"));
        toClose.add((Closeable)this.injector.getInstance(SearchService.class));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add((Closeable)this.injector.getInstance(TransportService.class));
        toClose.add(this.nodeService.getTaskCancellationMonitoringService());
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("script"));
        toClose.add((Closeable)this.injector.getInstance(ScriptService.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> ((ThreadPool)this.injector.getInstance(ThreadPool.class)).shutdown());
        toClose.add(() -> stopWatch.stop().start("gateway_meta_state"));
        toClose.add((Closeable)this.injector.getInstance(GatewayMetaState.class));
        toClose.add(() -> stopWatch.stop().start("node_environment"));
        toClose.add((Closeable)this.injector.getInstance(NodeEnvironment.class));
        toClose.add(() -> ((StopWatch)stopWatch).stop());
        if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.telemetry.enabled")) {
            toClose.add((Closeable)this.injector.getInstance(Tracer.class));
            toClose.add((Closeable)this.injector.getInstance(MetricsRegistry.class));
        }
        if (this.logger.isTraceEnabled()) {
            toClose.add(() -> this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint()));
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = (ThreadPool)this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate((ThreadPool)threadPool, (long)timeout, (TimeUnit)timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsDir().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format((InetSocketAddress)new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsDir().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    public static CircuitBreakerService createCircuitBreakerService(Settings settings, List<BreakerSettings> breakerSettings, ClusterSettings clusterSettings) {
        String type = (String)BREAKER_TYPE_KEY.get(settings);
        if (type.equals("hierarchy")) {
            return new HierarchyCircuitBreakerService(settings, breakerSettings, clusterSettings);
        }
        if (type.equals("none")) {
            return new NoneCircuitBreakerService();
        }
        throw new IllegalArgumentException("Unknown circuit breaker type [" + type + "]");
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    protected SearchService newSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor) {
        return new SearchService(clusterService, indicesService, threadPool, scriptService, bigArrays, queryPhase, fetchPhase, responseCollectorService, circuitBreakerService, indexSearcherExecutor);
    }

    protected ScriptService newScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts) {
        return new ScriptService(settings, engines, contexts);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings());
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        InternalClusterInfoService service = new InternalClusterInfoService(settings, clusterService, threadPool, (Client)client);
        if (DiscoveryNode.isClusterManagerNode((Settings)settings)) {
            clusterService.addListener((ClusterStateListener)service);
        }
        return service;
    }

    protected HttpServerTransport newHttpTransport(NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    private void initializeFileCache(Settings settings, CircuitBreaker circuitBreaker) throws IOException {
        if (DiscoveryNode.isSearchNode((Settings)settings)) {
            NodeEnvironment.NodePath fileCacheNodePath = this.nodeEnvironment.fileCacheNodePath();
            long capacity = ((ByteSizeValue)NODE_SEARCH_CACHE_SIZE_SETTING.get(settings)).getBytes();
            FsInfo.Path info = (FsInfo.Path)SkyliteExceptionsHelper.catchAsRuntimeException(() -> FsProbe.getFSInfo((NodeEnvironment.NodePath)fileCacheNodePath));
            long availableCapacity = info.getAvailable().getBytes();
            if (capacity == 0L) {
                if (DiscoveryNode.getRolesFromSettings((Settings)settings).stream().anyMatch(role -> !NodeRole.SEARCH_ROLE.equals(role))) {
                    throw new SettingsException("Unable to initialize the " + NodeRole.SEARCH_ROLE.roleName() + "-" + NodeRole.DATA_ROLE.roleName() + " node: Missing value for configuration " + NODE_SEARCH_CACHE_SIZE_SETTING.getKey());
                }
                capacity = 80L * availableCapacity / 100L;
            }
            capacity = Math.min(capacity, availableCapacity);
            fileCacheNodePath.fileCacheReservedSize = new ByteSizeValue(capacity, ByteSizeUnit.BYTES);
            this.fileCache = FileCacheFactory.createConcurrentLRUFileCache((long)capacity, (CircuitBreaker)circuitBreaker);
            List fileCacheDataPaths = NodeEnvironment.collectFileCacheDataPath((NodeEnvironment.NodePath)fileCacheNodePath);
            this.fileCache.restoreFromDirectory(fileCacheDataPaths);
        }
    }

    public FileCache fileCache() {
        return this.fileCache;
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;
        private final RemoteStoreNodeService remoteStoreNodeService;

        private LocalNodeFactory(Settings settings, String persistentNodeId, RemoteStoreNodeService remoteStoreNodeService) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
            this.remoteStoreNodeService = remoteStoreNodeService;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            if (RemoteStoreNodeAttribute.isRemoteStoreAttributePresent((Settings)this.settings)) {
                this.localNode.set((Object)LocalNodeFactory.createRemoteNodeLocal(this.settings, boundTransportAddress.publishAddress(), this.persistentNodeId, this.remoteStoreNodeService));
            } else {
                this.localNode.set((Object)DiscoveryNode.createLocal((Settings)this.settings, (TransportAddress)boundTransportAddress.publishAddress(), (String)this.persistentNodeId));
            }
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }

        private static DiscoveryNode createRemoteNodeLocal(Settings settings, TransportAddress publishAddress, String nodeId, RemoteStoreNodeService remoteStoreNodeService) {
            Map attributes = NodeSettings.NODE_ATTRIBUTES.getAsMap(settings);
            Set roles = DiscoveryNode.getRolesFromSettings((Settings)settings);
            DiscoveryNode discoveryNode = new DiscoveryNode((String)CommonSettings.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, Version.CURRENT);
            remoteStoreNodeService.createAndVerifyRepositories(discoveryNode);
            return discoveryNode;
        }
    }

    public static class DiscoverySettings {
        public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting((String)"discovery.initial_state_timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

        public static final class SettingsProviderImpl
        implements SettingsProvider {
            public List<? extends Setting<?>> getSettings() {
                return Collections.singletonList(INITIAL_STATE_TIMEOUT_SETTING);
            }
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(WRITE_PORTS_FILE_SETTING, BREAKER_TYPE_KEY, NODE_SEARCH_CACHE_SIZE_SETTING);
        }
    }
}

