/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import io.skylite.common.lifecycle.AbstractLifecycleComponent;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.node.NodeResourceUsageStats;
import io.skylite.core.node.NodesResourceUsageStats;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.node.resource.tracker.NodeResourceUsageTracker;

public class ResourceUsageCollectorService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static long REFRESH_INTERVAL_IN_MILLIS = 1000L;
    private static final Logger logger = LogManager.getLogger(ResourceUsageCollectorService.class);
    private final ConcurrentMap<String, NodeResourceUsageStats> nodeIdToResourceUsageStats = ConcurrentCollections.newConcurrentMap();
    private ThreadPool threadPool;
    private volatile Scheduler.Cancellable scheduledFuture;
    private NodeResourceUsageTracker nodeResourceUsageTracker;
    private ClusterService clusterService;

    public ResourceUsageCollectorService(NodeResourceUsageTracker nodeResourceUsageTracker, ClusterService clusterService, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.nodeResourceUsageTracker = nodeResourceUsageTracker;
        this.clusterService = clusterService;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.removeNodeResourceUsageStats(removedNode.getId());
            }
        }
    }

    void removeNodeResourceUsageStats(String nodeId) {
        this.nodeIdToResourceUsageStats.remove(nodeId);
    }

    public void collectNodeResourceUsageStats(String nodeId, long timestamp, double memoryUtilizationPercent, double cpuUtilizationPercent) {
        this.nodeIdToResourceUsageStats.compute(nodeId, (id, resourceUsageStats) -> {
            if (resourceUsageStats == null) {
                return new NodeResourceUsageStats(nodeId, timestamp, memoryUtilizationPercent, cpuUtilizationPercent);
            }
            resourceUsageStats.setCpuUtilizationPercent(cpuUtilizationPercent);
            resourceUsageStats.setMemoryUtilizationPercent(memoryUtilizationPercent);
            resourceUsageStats.setTimestamp(timestamp);
            return resourceUsageStats;
        });
    }

    public Map<String, NodeResourceUsageStats> getAllNodeStatistics() {
        HashMap<String, NodeResourceUsageStats> nodeStats = new HashMap<String, NodeResourceUsageStats>(this.nodeIdToResourceUsageStats.size());
        this.nodeIdToResourceUsageStats.forEach((nodeId, resourceUsageStats) -> nodeStats.put((String)nodeId, new NodeResourceUsageStats(resourceUsageStats)));
        return nodeStats;
    }

    public Optional<NodeResourceUsageStats> getNodeStatistics(String nodeId) {
        return Optional.ofNullable((NodeResourceUsageStats)this.nodeIdToResourceUsageStats.get(nodeId)).map(resourceUsageStats -> new NodeResourceUsageStats(resourceUsageStats));
    }

    public NodesResourceUsageStats stats() {
        return new NodesResourceUsageStats(this.getAllNodeStatistics());
    }

    private void collectLocalNodeResourceUsageStats() {
        if (this.nodeResourceUsageTracker.isReady() && this.clusterService.state() != null) {
            this.collectNodeResourceUsageStats(this.clusterService.state().nodes().getLocalNodeId(), System.currentTimeMillis(), this.nodeResourceUsageTracker.getMemoryUtilizationPercent(), this.nodeResourceUsageTracker.getCpuUtilizationPercent());
        }
    }

    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.collectLocalNodeResourceUsageStats();
            }
            catch (Exception e) {
                logger.warn("failure in ResourceUsageCollectorService", (Throwable)e);
            }
        }, new TimeValue(REFRESH_INTERVAL_IN_MILLIS), "generic");
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() {
    }
}

