/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.tasks.TaskManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksNodeService;
import org.opensearch.persistent.PersistentTasksService;

public class AllocatedPersistentTask
extends CancellableTask {
    private static final Logger logger = LogManager.getLogger(AllocatedPersistentTask.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.STARTED);
    private volatile String persistentTaskId;
    private volatile long allocationId;
    @Nullable
    private volatile Exception failure;
    private volatile PersistentTasksService persistentTasksService;
    private volatile TaskManager taskManager;

    public AllocatedPersistentTask(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        super(id, type, action, description, parentTask, headers);
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public final boolean cancelOnParentLeaving() {
        return false;
    }

    public Task.Status getStatus() {
        return new PersistentTasksNodeService.Status(this.state.get());
    }

    public void updatePersistentTaskState(PersistentTaskState state, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.persistentTasksService.sendUpdateStateRequest(this.persistentTaskId, this.allocationId, state, listener);
    }

    public String getPersistentTaskId() {
        return this.persistentTaskId;
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        this.persistentTasksService = persistentTasksService;
        this.taskManager = taskManager;
        this.persistentTaskId = persistentTaskId;
        this.allocationId = allocationId;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    public void waitForPersistentTask(Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, PersistentTasksService.WaitForPersistentTaskListener<?> listener) {
        this.persistentTasksService.waitForPersistentTaskCondition(this.persistentTaskId, predicate, timeout, listener);
    }

    protected final boolean isCompleted() {
        return this.state.get() == State.COMPLETED;
    }

    boolean markAsCancelled() {
        return this.state.compareAndSet(State.STARTED, State.PENDING_CANCEL);
    }

    public void markAsCompleted() {
        this.completeAndNotifyIfNeeded(null);
    }

    public void markAsFailed(Exception e) {
        if ("by user request".equals(this.getReasonCancelled())) {
            this.completeAndNotifyIfNeeded(null);
        } else {
            this.completeAndNotifyIfNeeded(e);
        }
    }

    private void completeAndNotifyIfNeeded(@Nullable Exception failure) {
        State prevState = this.state.getAndSet(State.COMPLETED);
        if (prevState == State.COMPLETED) {
            logger.warn("attempt to complete task [{}] with id [{}] in the [{}] state", (Object)this.getAction(), (Object)this.getPersistentTaskId(), (Object)prevState);
        } else {
            if (failure != null) {
                logger.warn(() -> new ParameterizedMessage("task {} failed with an exception", (Object)this.getPersistentTaskId()), (Throwable)failure);
            }
            try {
                this.failure = failure;
                if (prevState == State.STARTED) {
                    logger.trace("sending notification for completed task [{}] with id [{}]", (Object)this.getAction(), (Object)this.getPersistentTaskId());
                    this.persistentTasksService.sendCompletionRequest(this.getPersistentTaskId(), this.getAllocationId(), failure, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                        public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                            logger.trace("notification for task [{}] with id [{}] was successful", (Object)AllocatedPersistentTask.this.getAction(), (Object)AllocatedPersistentTask.this.getPersistentTaskId());
                        }

                        public void onFailure(Exception e) {
                            logger.warn(() -> new ParameterizedMessage("notification for task [{}] with id [{}] failed", (Object)AllocatedPersistentTask.this.getAction(), (Object)AllocatedPersistentTask.this.getPersistentTaskId()), (Throwable)e);
                        }
                    });
                }
            }
            finally {
                this.taskManager.unregister((Task)this);
            }
        }
    }

    public static enum State {
        STARTED,
        PENDING_CANCEL,
        COMPLETED;

    }
}

