/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.clustermanager.ClusterManagerNodeOperationRequestBuilder;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.persistent.PersistentTaskResponse;
import org.opensearch.persistent.PersistentTasksClusterService;
import org.opensearch.persistent.PersistentTasksCustomMetadata;

public class CompletionPersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final CompletionPersistentTaskAction INSTANCE = new CompletionPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/completion";

    private CompletionPersistentTaskAction() {
        super(NAME, PersistentTaskResponse::new);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return INSTANCE;
        }

        public Class<? extends io.skylite.core.action.support.TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAction.class;
        }
    }

    public static class TransportAction
    extends TransportClusterManagerNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(CompletionPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        protected String executor() {
            return "generic";
        }

        protected PersistentTaskResponse read(StreamInput in) throws IOException {
            return new PersistentTaskResponse(in);
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected final void clusterManagerOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.completePersistentTask(request.taskId, request.allocationId, request.exception, ActionListenerHelper.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse((Object)new PersistentTaskResponse((PersistentTasksCustomMetadata.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends ClusterManagerNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(SkyliteClient client, CompletionPersistentTaskAction action) {
            super(client, (ActionType)action, (ClusterManagerNodeRequest)new Request());
        }
    }

    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private String taskId;
        private Exception exception;
        private long allocationId = -1L;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.exception = in.readException();
        }

        public Request(String taskId, long allocationId, Exception exception) {
            this.taskId = taskId;
            this.exception = exception;
            this.allocationId = allocationId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeException((Throwable)this.exception);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError((String)"task id is missing", validationException);
            }
            if (this.allocationId < 0L) {
                validationException = ValidateActions.addValidationError((String)"allocation id is negative or missing", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.exception, request.exception);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.exception);
        }
    }
}

