/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent.decider;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opensearch.persistent.decider.AssignmentDecision;

public class EnableAssignmentDecider {
    public static final Setting<Allocation> CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING = new Setting("cluster.persistent_tasks.allocation.enable", Allocation.ALL.toString(), Allocation::fromString, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final String ALLOCATION_NONE_EXPLANATION = "no persistent task assignments are allowed due to cluster settings";
    private volatile Allocation enableAssignment;

    public EnableAssignmentDecider(Settings settings, ClusterSettings clusterSettings) {
        this.enableAssignment = (Allocation)((Object)CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING, this::setEnableAssignment);
    }

    public void setEnableAssignment(Allocation enableAssignment) {
        this.enableAssignment = enableAssignment;
    }

    public AssignmentDecision canAssign() {
        if (this.enableAssignment == Allocation.NONE) {
            return new AssignmentDecision(AssignmentDecision.Type.NO, ALLOCATION_NONE_EXPLANATION);
        }
        return AssignmentDecision.YES;
    }

    public static enum Allocation {
        NONE,
        ALL;


        public static Allocation fromString(String strValue) {
            if (strValue == null) {
                return null;
            }
            String value = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal value [" + value + "] for [" + CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.getKey() + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING);
        }
    }
}

