/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlMode;

public final class AdmissionControlSettings {
    public static final Setting<AdmissionControlMode> ADMISSION_CONTROL_TRANSPORT_LAYER_MODE = new Setting("admission_control.transport.mode", "disabled", AdmissionControlMode::fromName, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile AdmissionControlMode transportLayeradmissionControlMode;

    public AdmissionControlSettings(ClusterSettings clusterSettings, Settings settings) {
        this.transportLayeradmissionControlMode = (AdmissionControlMode)((Object)ADMISSION_CONTROL_TRANSPORT_LAYER_MODE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(ADMISSION_CONTROL_TRANSPORT_LAYER_MODE, this::setAdmissionControlTransportLayerMode);
    }

    private void setAdmissionControlTransportLayerMode(AdmissionControlMode admissionControlMode) {
        this.transportLayeradmissionControlMode = admissionControlMode;
    }

    public AdmissionControlMode getAdmissionControlTransportLayerMode() {
        return this.transportLayeradmissionControlMode;
    }

    public Boolean isTransportLayerAdmissionControlEnforced() {
        return this.transportLayeradmissionControlMode == AdmissionControlMode.ENFORCED;
    }

    public Boolean isTransportLayerAdmissionControlEnabled() {
        return this.transportLayeradmissionControlMode != AdmissionControlMode.DISABLED;
    }

    public static class Defaults {
        public static final String MODE = "disabled";
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(ADMISSION_CONTROL_TRANSPORT_LAYER_MODE);
        }
    }
}

