/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.settings;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlSettings;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlMode;

public class CPUBasedAdmissionControllerSettings {
    public static final String CPU_BASED_ADMISSION_CONTROLLER = "global_cpu_usage";
    private AdmissionControlMode transportLayerMode;
    private Long searchCPULimit;
    private Long indexingCPULimit;
    private final List<String> transportActionsList;
    public static final Setting<AdmissionControlMode> CPU_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE = new Setting("admission_control.transport.cpu_usage.mode_override", AdmissionControlSettings.ADMISSION_CONTROL_TRANSPORT_LAYER_MODE, AdmissionControlMode::fromName, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Long> SEARCH_CPU_USAGE_LIMIT = Setting.longSetting((String)"admission_control.search.cpu_usage.limit", (long)95L, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Long> INDEXING_CPU_USAGE_LIMIT = Setting.longSetting((String)"admission_control.indexing.cpu_usage.limit", (long)95L, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});

    public CPUBasedAdmissionControllerSettings(ClusterSettings clusterSettings, Settings settings) {
        this.transportLayerMode = (AdmissionControlMode)((Object)CPU_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CPU_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE, this::setTransportLayerMode);
        this.searchCPULimit = (Long)SEARCH_CPU_USAGE_LIMIT.get(settings);
        this.indexingCPULimit = (Long)INDEXING_CPU_USAGE_LIMIT.get(settings);
        this.transportActionsList = Defaults.TRANSPORT_LAYER_DEFAULT_URI_TYPE;
        clusterSettings.addSettingsUpdateConsumer(INDEXING_CPU_USAGE_LIMIT, this::setIndexingCPULimit);
        clusterSettings.addSettingsUpdateConsumer(SEARCH_CPU_USAGE_LIMIT, this::setSearchCPULimit);
    }

    private void setTransportLayerMode(AdmissionControlMode admissionControlMode) {
        this.transportLayerMode = admissionControlMode;
    }

    public AdmissionControlMode getTransportLayerAdmissionControllerMode() {
        return this.transportLayerMode;
    }

    public Long getSearchCPULimit() {
        return this.searchCPULimit;
    }

    public Long getIndexingCPULimit() {
        return this.indexingCPULimit;
    }

    public void setIndexingCPULimit(Long indexingCPULimit) {
        this.indexingCPULimit = indexingCPULimit;
    }

    public void setSearchCPULimit(Long searchCPULimit) {
        this.searchCPULimit = searchCPULimit;
    }

    public List<String> getTransportActionsList() {
        return this.transportActionsList;
    }

    public static class Defaults {
        public static final long CPU_USAGE = 95L;
        public static List<String> TRANSPORT_LAYER_DEFAULT_URI_TYPE = Arrays.asList("indexing", "search");
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(CPU_BASED_ADMISSION_CONTROLLER_TRANSPORT_LAYER_MODE, INDEXING_CPU_USAGE_LIMIT, SEARCH_CPU_USAGE_LIMIT);
        }
    }
}

