/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.transport;

import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlService;

public class AdmissionControlTransportHandler<T extends TransportRequest>
implements TransportRequestHandler<T> {
    private final String action;
    private final TransportRequestHandler<T> actualHandler;
    protected final Logger log = LogManager.getLogger(this.getClass());
    AdmissionControlService admissionControlService;
    boolean forceExecution;

    public AdmissionControlTransportHandler(String action, TransportRequestHandler<T> actualHandler, AdmissionControlService admissionControlService, boolean forceExecution) {
        this.action = action;
        this.actualHandler = actualHandler;
        this.admissionControlService = admissionControlService;
        this.forceExecution = forceExecution;
    }

    public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
        try {
            this.admissionControlService.applyTransportAdmissionControl(this.action);
        }
        catch (SkyliteRejectedExecutionException skyliteRejectedExecutionException) {
            this.log.warn(skyliteRejectedExecutionException.getMessage());
            channel.sendResponse((Exception)((Object)skyliteRejectedExecutionException));
        }
        catch (Exception e) {
            throw e;
        }
        this.actualHandler.messageReceived(request, channel, task);
    }
}

