/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import io.skylite.SkyliteParseException;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.rest.StreamingRestChannel;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.tasks.Task;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.rest.BytesRestResponse;

public abstract class BaseRestHandler
implements RestHandler {
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting((String)"rest.action.multi.allow_explicit_index", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final LongAdder usageCount = new LongAdder();
    @Deprecated
    protected Logger logger = LogManager.getLogger(this.getClass());

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    public abstract String getName();

    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestChannelConsumer action = this.prepareRequest(request, client);
        SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams().contains(p)).collect(Collectors.toCollection(TreeSet::new));
        if (!unconsumedParams.isEmpty()) {
            HashSet<String> candidateParams = new HashSet<String>();
            candidateParams.addAll(request.consumedParams());
            candidateParams.addAll(this.responseParams());
            throw new IllegalArgumentException(this.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
        }
        if (request.hasContent() && !request.isContentConsumed()) {
            throw new IllegalArgumentException("request [" + String.valueOf(request.method()) + " " + request.path() + "] does not support having a body");
        }
        this.usageCount.increment();
        action.accept(channel);
    }

    public static String unrecognizedStrings(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder(String.format(Locale.ROOT, "request [%s] contains unrecognized %s%s: ", request.path(), detail, invalids.size() > 1 ? "s" : ""));
        boolean first = true;
        for (String invalid : invalids) {
            LevenshteinDistance ld = new LevenshteinDistance();
            ArrayList<Tuple> scoredParams = new ArrayList<Tuple>();
            for (String candidate : candidates) {
                float distance = ld.getDistance(invalid, candidate);
                if (!(distance > 0.5f)) continue;
                scoredParams.add(new Tuple((Object)Float.valueOf(distance), (Object)candidate));
            }
            CollectionUtil.timSort(scoredParams, (a, b) -> {
                int compare = ((Float)a.v1()).compareTo((Float)b.v1());
                if (compare != 0) {
                    return -compare;
                }
                return ((String)a.v2()).compareTo((String)b.v2());
            });
            if (!first) {
                message.append(", ");
            }
            message.append("[").append(invalid).append("]");
            List keys = scoredParams.stream().map(Tuple::v2).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                message.append(" -> did you mean ");
                if (keys.size() == 1) {
                    message.append("[").append((String)keys.get(0)).append("]");
                } else {
                    message.append("any of ").append(keys.toString());
                }
                message.append("?");
            }
            first = false;
        }
        return message.toString();
    }

    protected final String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        return BaseRestHandler.unrecognizedStrings(request, invalids, candidates, detail);
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    public static void parseDeprecatedMasterTimeoutParameter(ClusterManagerNodeRequest mnr, RestRequest request, DeprecationLogger logger, String logMsgKeyPrefix) {
        String MASTER_TIMEOUT_DEPRECATED_MESSAGE = "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.";
        String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";
        if (request.hasParam("master_timeout")) {
            logger.deprecate(logMsgKeyPrefix + "_master_timeout_parameter", "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.", new Object[0]);
            if (request.hasParam("cluster_manager_timeout")) {
                throw new SkyliteParseException("Please only use one of the request parameters [master_timeout, cluster_manager_timeout].", new Object[0]);
            }
            mnr.clusterManagerNodeTimeout(request.paramAsTime("master_timeout", mnr.clusterManagerNodeTimeout()));
        }
    }

    public RestChannelConsumer sendTask(String nodeId, Task task) {
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", nodeId + ":" + task.getId());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception> {
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(MULTI_ALLOW_EXPLICIT_INDEX);
        }
    }

    public static class Wrapper
    extends BaseRestHandler {
        protected final BaseRestHandler delegate;

        public Wrapper(BaseRestHandler delegate) {
            this.delegate = Objects.requireNonNull(delegate, "BaseRestHandler delegate can not be null");
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        public List<RestHandler.Route> routes() {
            return this.delegate.routes();
        }

        public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
            return this.delegate.deprecatedRoutes();
        }

        public List<RestHandler.ReplacedRoute> replacedRoutes() {
            return this.delegate.replacedRoutes();
        }

        @Override
        protected RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            return this.delegate.prepareRequest(request, client);
        }

        @Override
        protected Set<String> responseParams() {
            return this.delegate.responseParams();
        }

        public boolean canTripCircuitBreaker() {
            return this.delegate.canTripCircuitBreaker();
        }

        public boolean supportsContentStream() {
            return this.delegate.supportsContentStream();
        }

        public boolean allowsUnsafeBuffers() {
            return this.delegate.allowsUnsafeBuffers();
        }

        public boolean allowSystemIndexAccessByDefault() {
            return this.delegate.allowSystemIndexAccessByDefault();
        }

        public boolean supportsStreaming() {
            return this.delegate.supportsStreaming();
        }
    }

    @FunctionalInterface
    @ExperimentalApi
    protected static interface StreamingRestChannelConsumer
    extends CheckedConsumer<StreamingRestChannel, Exception> {
    }
}

