/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action;

import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.common.ParsingException;
import io.skylite.core.index.query.Operator;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestBuilderListener;

public class RestActions {
    public static long parseVersion(RestRequest request) {
        if (request.hasParam("version")) {
            return request.paramAsLong("version", -3L);
        }
        String ifMatch = request.header("If-Match");
        if (ifMatch != null) {
            return Long.parseLong(ifMatch);
        }
        return -3L;
    }

    public static long parseVersion(RestRequest request, long defaultVersion) {
        long version = RestActions.parseVersion(request);
        return version == -3L ? defaultVersion : version;
    }

    public static <NodeResponse extends BaseNodeResponse> void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, BaseNodesResponse<NodeResponse> response) throws IOException {
        int successful = response.getNodes().size();
        int failed = response.failures().size();
        RestActions.buildNodesHeader(builder, params, successful + failed, successful, failed, response.failures());
    }

    public static void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int failed, List<FailedNodeException> failures) throws IOException {
        builder.startObject("_nodes");
        builder.field("total", total);
        builder.field("successful", successful);
        builder.field("failed", failed);
        if (!failures.isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException failure : failures) {
                builder.startObject();
                failure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodesResponse extends BaseNodesResponse> BytesRestResponse nodesResponse(XContentBuilder builder, ToXContent.Params params, NodesResponse response) throws IOException {
        builder.startObject();
        RestActions.buildNodesHeader(builder, params, response);
        builder.field("cluster_name", response.getClusterName().value());
        ((ToXContent)response).toXContent(builder, params);
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    public static QueryBuilder urlParamsToQueryBuilder(RestRequest request) {
        String queryString = request.param("q");
        if (queryString == null) {
            return null;
        }
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery(queryString);
        queryBuilder.defaultField(request.param("df"));
        queryBuilder.analyzer(request.param("analyzer"));
        queryBuilder.analyzeWildcard(Boolean.valueOf(request.paramAsBoolean("analyze_wildcard", false)));
        queryBuilder.lenient(request.paramAsBoolean("lenient", null));
        String defaultOperator = request.param("default_operator");
        if (defaultOperator != null) {
            queryBuilder.defaultOperator(Operator.fromString((String)defaultOperator));
        }
        return queryBuilder;
    }

    public static QueryBuilder getQueryContent(XContentParser requestParser) {
        return RestActions.parseTopLevelQueryBuilder("query", requestParser);
    }

    public static QueryBuilder getQueryContent(String fieldName, XContentParser requestParser) {
        return RestActions.parseTopLevelQueryBuilder(fieldName, requestParser);
    }

    private static QueryBuilder parseTopLevelQueryBuilder(String fieldName, XContentParser parser) {
        try {
            QueryBuilder queryBuilder = null;
            XContentParser.Token first = parser.nextToken();
            if (first == null) {
                return null;
            }
            if (first != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(first) + "]", new Object[]{parser.getTokenLocation()});
            }
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentName = parser.currentName();
                    if (fieldName.equals(currentName)) {
                        queryBuilder = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    } else {
                        throw new ParsingException(parser.getTokenLocation(), "request does not support [" + parser.currentName() + "]", new Object[0]);
                    }
                }
                token = parser.nextToken();
            }
            return queryBuilder;
        }
        catch (ParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingException(parser == null ? null : parser.getTokenLocation(), "Failed to parse", (Throwable)e, new Object[0]);
        }
    }

    public static class NodesResponseRestListener<NodesResponse extends BaseNodesResponse>
    extends RestBuilderListener<NodesResponse> {
        public NodesResponseRestListener(RestChannel channel) {
            super(channel);
        }

        @Override
        public RestResponse buildResponse(NodesResponse response, XContentBuilder builder) throws Exception {
            return RestActions.nodesResponse(builder, (ToXContent.Params)this.channel.request(), response);
        }
    }
}

