/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action;

import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.StatusToXContentObject;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.util.function.Function;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestStatusToXContentListener<Response extends StatusToXContentObject>
extends RestToXContentListener<Response> {
    private final Function<Response, String> extractLocation;

    public RestStatusToXContentListener(RestChannel channel) {
        this(channel, r -> {
            assert (false) : "Returned a 201 CREATED but not set up to support a Location header";
            return null;
        });
    }

    public RestStatusToXContentListener(RestChannel channel, Function<Response, String> extractLocation) {
        super(channel);
        this.extractLocation = extractLocation;
    }

    @Override
    public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
        String location;
        assert (!response.isFragment());
        response.toXContent(builder, (ToXContent.Params)this.channel.request());
        BytesRestResponse restResponse = new BytesRestResponse(response.status(), builder);
        if (RestStatus.CREATED == restResponse.status() && (location = this.extractLocation.apply(response)) != null) {
            restResponse.addHeader("Location", location);
        }
        return restResponse;
    }
}

