/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestCloneSnapshotAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestCloneSnapshotAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_snapshot/{repository}/{snapshot}/_clone/{target_snapshot}"));
    }

    @Override
    public String getName() {
        return "clone_snapshot_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map source = request.contentParser().map();
        CloneSnapshotRequest cloneSnapshotRequest = new CloneSnapshotRequest(request.param("repository"), request.param("snapshot"), request.param("target_snapshot"), XContentMapValuesUtil.nodeStringArrayValue(source.getOrDefault("indices", Collections.emptyList())));
        cloneSnapshotRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", cloneSnapshotRequest.clusterManagerNodeTimeout()));
        RestCloneSnapshotAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)cloneSnapshotRequest, request, deprecationLogger, this.getName());
        cloneSnapshotRequest.indicesOptions(IndicesOptions.fromMap((Map)source, (IndicesOptions)cloneSnapshotRequest.indicesOptions()));
        return channel -> client.admin().cluster().cloneSnapshot(cloneSnapshotRequest, new RestToXContentListener((RestChannel)channel));
    }
}

