/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import io.skylite.core.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestBuilderListener;

public class RestClusterAllocationExplainAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/allocation/explain"), new RestHandler.Route(RestRequest.Method.POST, "/_cluster/allocation/explain")));
    }

    @Override
    public String getName() {
        return "cluster_allocation_explain_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterAllocationExplainRequest req;
        if (!request.hasContentOrSourceParam()) {
            req = new ClusterAllocationExplainRequest();
        } else {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                req = ClusterAllocationExplainRequest.parse((XContentParser)parser);
            }
        }
        req.includeYesDecisions(request.paramAsBoolean("include_yes_decisions", false));
        req.includeDiskInfo(request.paramAsBoolean("include_disk_info", false));
        return channel -> client.admin().cluster().allocationExplain(req, (ActionListener)new RestBuilderListener<ClusterAllocationExplainResponse>(this, channel){

            @Override
            public RestResponse buildResponse(ClusterAllocationExplainResponse response, XContentBuilder builder) throws IOException {
                response.getExplanation().toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

