/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestClusterDeleteWeightedRoutingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestClusterDeleteWeightedRoutingAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.DELETE, "/_cluster/routing/awareness/weights"), new RestHandler.Route(RestRequest.Method.DELETE, "/_cluster/routing/awareness/{attribute}/weights")));
    }

    @Override
    public String getName() {
        return "delete_weighted_routing_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterDeleteWeightedRoutingRequest clusterDeleteWeightedRoutingRequest = RestClusterDeleteWeightedRoutingAction.createRequest(request);
        return channel -> client.admin().cluster().deleteWeightedRouting(clusterDeleteWeightedRoutingRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static ClusterDeleteWeightedRoutingRequest createRequest(RestRequest request) throws IOException {
        ClusterDeleteWeightedRoutingRequest deleteWeightedRoutingRequest = new ClusterDeleteWeightedRoutingRequest(request.param("attribute"));
        request.applyContentParser(p -> deleteWeightedRoutingRequest.source(p.mapStrings()));
        return deleteWeightedRoutingRequest;
    }
}

