/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestClusterHealthAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestClusterHealthAction.class);
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("level");

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/health"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/health/{index}")));
    }

    @Override
    public String getName() {
        return "cluster_health_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterHealthRequest clusterHealthRequest = RestClusterHealthAction.fromRequest(request);
        return channel -> client.admin().cluster().health(clusterHealthRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    public static ClusterHealthRequest fromRequest(RestRequest request) {
        String waitForStatus;
        String level;
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        clusterHealthRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)clusterHealthRequest.indicesOptions()));
        clusterHealthRequest.local(request.paramAsBoolean("local", clusterHealthRequest.local()));
        clusterHealthRequest.ensureNodeWeighedIn(request.paramAsBoolean("ensure_node_weighed_in", clusterHealthRequest.ensureNodeWeighedIn()));
        clusterHealthRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterHealthRequest.clusterManagerNodeTimeout()));
        RestClusterHealthAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterHealthRequest, request, deprecationLogger, "cluster_health");
        clusterHealthRequest.timeout(request.paramAsTime("timeout", clusterHealthRequest.timeout()));
        String awarenessAttribute = request.param("awareness_attribute");
        if (awarenessAttribute != null) {
            clusterHealthRequest.setAwarenessAttribute(awarenessAttribute);
        }
        if ((level = request.param("level")) != null) {
            clusterHealthRequest.setLevel(level);
        }
        if ((waitForStatus = request.param("wait_for_status")) != null) {
            clusterHealthRequest.waitForStatus(ClusterHealthStatus.valueOf((String)waitForStatus.toUpperCase(Locale.ROOT)));
        }
        clusterHealthRequest.waitForNoRelocatingShards(request.paramAsBoolean("wait_for_no_relocating_shards", clusterHealthRequest.waitForNoRelocatingShards()));
        clusterHealthRequest.waitForNoInitializingShards(request.paramAsBoolean("wait_for_no_initializing_shards", clusterHealthRequest.waitForNoInitializingShards()));
        if (request.hasParam("wait_for_relocating_shards")) {
            throw new IllegalArgumentException("wait_for_relocating_shards has been removed, use wait_for_no_relocating_shards [true/false] instead");
        }
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            clusterHealthRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        clusterHealthRequest.waitForNodes(request.param("wait_for_nodes", clusterHealthRequest.waitForNodes()));
        if (request.param("wait_for_events") != null) {
            clusterHealthRequest.waitForEvents(Priority.valueOf((String)request.param("wait_for_events").toUpperCase(Locale.ROOT)));
        }
        return clusterHealthRequest;
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }
}

