/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestClusterPutWeightedRoutingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestClusterPutWeightedRoutingAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_cluster/routing/awareness/{attribute}/weights"));
    }

    @Override
    public String getName() {
        return "put_weighted_routing_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterPutWeightedRoutingRequest putWeightedRoutingRequest = RestClusterPutWeightedRoutingAction.createRequest(request);
        return channel -> client.admin().cluster().putWeightedRouting(putWeightedRoutingRequest, new RestToXContentListener((RestChannel)channel));
    }

    public static ClusterPutWeightedRoutingRequest createRequest(RestRequest request) throws IOException {
        ClusterPutWeightedRoutingRequest putWeightedRoutingRequest = new ClusterPutWeightedRoutingRequest(request.param("attribute"));
        request.applyContentParser(p -> putWeightedRoutingRequest.source(p.mapOrdered()));
        return putWeightedRoutingRequest;
    }
}

