/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.ParseField;
import io.skylite.core.action.admin.cluster.reroute.ClusterRerouteRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.routing.allocation.AllocationCommands;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestClusterRerouteAction
extends BaseRestHandler {
    private static final ObjectParser<ClusterRerouteRequest, Void> PARSER = new ObjectParser("cluster_reroute");
    private static final String DEFAULT_METRICS;
    private final SettingsFilter settingsFilter;
    private static final DeprecationLogger deprecationLogger;
    private static final String DEPRECATED_MESSAGE_MASTER_NODE = "Assigning [master_node] to parameter [metric] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_node] instead.";
    private static final Set<String> RESPONSE_PARAMS;

    public RestClusterRerouteAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_cluster/reroute"));
    }

    @Override
    public String getName() {
        return "cluster_reroute_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String metric;
        ClusterRerouteRequest clusterRerouteRequest = RestClusterRerouteAction.createRequest(request);
        request.addSettingFilterParams(this.settingsFilter);
        if (clusterRerouteRequest.explain()) {
            request.params().put("explain", Boolean.TRUE.toString());
        }
        if ((metric = request.param("metric")) == null) {
            request.params().put("metric", DEFAULT_METRICS);
        } else {
            EnumSet metrics = ClusterState.Metric.parseString((String)request.param("metric"), (boolean)true);
            if (!metrics.equals(EnumSet.allOf(ClusterState.Metric.class)) && metrics.contains(ClusterState.Metric.MASTER_NODE)) {
                deprecationLogger.deprecate("cluster_reroute_metric_parameter_master_node_value", DEPRECATED_MESSAGE_MASTER_NODE, new Object[0]);
            }
        }
        return channel -> client.admin().cluster().reroute(clusterRerouteRequest, new RestToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    public static ClusterRerouteRequest createRequest(RestRequest request) throws IOException {
        ClusterRerouteRequest clusterRerouteRequest = new ClusterRerouteRequest();
        clusterRerouteRequest.dryRun(request.paramAsBoolean("dry_run", clusterRerouteRequest.dryRun()));
        clusterRerouteRequest.explain(request.paramAsBoolean("explain", clusterRerouteRequest.explain()));
        clusterRerouteRequest.timeout(request.paramAsTime("timeout", clusterRerouteRequest.timeout()));
        clusterRerouteRequest.setRetryFailed(request.paramAsBoolean("retry_failed", clusterRerouteRequest.isRetryFailed()));
        clusterRerouteRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterRerouteRequest.clusterManagerNodeTimeout()));
        RestClusterRerouteAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterRerouteRequest, request, deprecationLogger, "cluster_reroute");
        request.applyContentParser(parser -> PARSER.parse(parser, (Object)clusterRerouteRequest, null));
        return clusterRerouteRequest;
    }

    static {
        PARSER.declareField((p, v, c) -> v.commands(AllocationCommands.fromXContent((XContentParser)p)), new ParseField("commands", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareBoolean(ClusterRerouteRequest::dryRun, new ParseField("dry_run", new String[0]));
        DEFAULT_METRICS = Strings.arrayToCommaDelimitedString((Object[])EnumSet.complementOf(EnumSet.of(ClusterState.Metric.METADATA)).toArray());
        deprecationLogger = DeprecationLogger.getLogger(RestClusterRerouteAction.class);
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("metric");
        responseParams.addAll(Settings.FORMAT_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

