/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeleteStoredScriptAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestDeleteStoredScriptAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_scripts/{id}"));
    }

    @Override
    public String getName() {
        return "delete_stored_script_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        DeleteStoredScriptRequest deleteStoredScriptRequest = new DeleteStoredScriptRequest(id);
        deleteStoredScriptRequest.timeout(request.paramAsTime("timeout", deleteStoredScriptRequest.timeout()));
        deleteStoredScriptRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", deleteStoredScriptRequest.clusterManagerNodeTimeout()));
        RestDeleteStoredScriptAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)deleteStoredScriptRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().deleteStoredScript(deleteStoredScriptRequest, new RestToXContentListener((RestChannel)channel));
    }
}

