/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestGetStoredScriptAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetStoredScriptAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_scripts/{id}"));
    }

    @Override
    public String getName() {
        return "get_stored_scripts_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        GetStoredScriptRequest getRequest = new GetStoredScriptRequest(id);
        getRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRequest.clusterManagerNodeTimeout()));
        RestGetStoredScriptAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().getStoredScript(getRequest, new RestStatusToXContentListener((RestChannel)channel));
    }
}

