/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.util.set.Sets;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;

public class RestNodesInfoAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = NodesInfoRequest.Metric.allMetrics();
    private final SettingsFilter settingsFilter;

    public RestNodesInfoAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/{metrics}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/info/{metrics}")));
    }

    @Override
    public String getName() {
        return "nodes_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesInfoRequest nodesInfoRequest = RestNodesInfoAction.prepareRequest(request);
        nodesInfoRequest.timeout(request.param("timeout"));
        request.addSettingFilterParams(this.settingsFilter);
        return channel -> client.admin().cluster().nodesInfo(nodesInfoRequest, new RestActions.NodesResponseRestListener((RestChannel)channel));
    }

    static NodesInfoRequest prepareRequest(RestRequest request) {
        Set metrics;
        String[] nodeIds;
        if (request.hasParam("nodeId") && !request.hasParam("metrics")) {
            String nodeId = request.param("nodeId", "_all");
            Set metricsOrNodeIds = Strings.tokenizeByCommaToSet((String)nodeId);
            boolean isMetricsOnly = ALLOWED_METRICS.containsAll(metricsOrNodeIds);
            if (isMetricsOnly) {
                nodeIds = new String[]{"_all"};
                metrics = metricsOrNodeIds;
            } else {
                nodeIds = Strings.tokenizeToStringArray((String)nodeId, (String)",");
                metrics = Sets.newHashSet((Object[])new String[]{"_all"});
            }
        } else {
            nodeIds = Strings.tokenizeToStringArray((String)request.param("nodeId", "_all"), (String)",");
            metrics = Strings.tokenizeByCommaToSet((String)request.param("metrics", "_all"));
        }
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodeIds);
        nodesInfoRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesInfoRequest.all();
        } else {
            nodesInfoRequest.clear();
            metrics.retainAll(ALLOWED_METRICS);
            nodesInfoRequest.addMetrics((String[])metrics.stream().toArray(String[]::new));
        }
        return nodesInfoRequest;
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }
}

