/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.SecureString;
import io.skylite.common.action.ActionListener;
import io.skylite.core.ParseField;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequestBuilder;
import io.skylite.core.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestRequestFilter;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestBuilderListener;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler
implements RestRequestFilter {
    static final ObjectParser<NodesReloadSecureSettingsRequest, String> PARSER = new ObjectParser("reload_secure_settings", NodesReloadSecureSettingsRequest::new);
    private static final Set<String> FILTERED_FIELDS;

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_nodes/reload_secure_settings"), new RestHandler.Route(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        final NodesReloadSecureSettingsRequestBuilder nodesRequestBuilder = (NodesReloadSecureSettingsRequestBuilder)((NodesReloadSecureSettingsRequestBuilder)client.admin().cluster().prepareReloadSecureSettings().setTimeout(request.param("timeout"))).setNodesIds(nodesIds);
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                NodesReloadSecureSettingsRequest nodesRequest = (NodesReloadSecureSettingsRequest)PARSER.parse(parser, null);
                nodesRequestBuilder.setSecureStorePassword(nodesRequest.getSecureSettingsPassword());
            }
        });
        return channel -> nodesRequestBuilder.execute((ActionListener)new RestBuilderListener<NodesReloadSecureSettingsResponse>(this, channel){

            @Override
            public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, (ToXContent.Params)this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, (ToXContent.Params)this.channel.request());
                builder.endObject();
                ((NodesReloadSecureSettingsRequest)nodesRequestBuilder.request()).closePassword();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString((request, value) -> request.setSecureStorePassword(new SecureString(value.toCharArray())), new ParseField("secure_settings_password", new String[0]));
        FILTERED_FIELDS = Collections.singleton("secure_settings_password");
    }
}

