/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.admin.indices.RestIndexPutAliasAction;

public class RestCreateIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestIndexPutAliasAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/{index}"));
    }

    @Override
    public String getName() {
        return "create_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(request.param("index"));
        if (request.hasContent()) {
            Map<String, Object> sourceAsMap = (Map<String, Object>)XContentHelper.convertToMap((BytesReference)request.requiredContent(), (boolean)false, (MediaType)request.getMediaType()).v2();
            sourceAsMap = RestCreateIndexAction.prepareMappings(sourceAsMap);
            createIndexRequest.source(sourceAsMap, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        }
        createIndexRequest.timeout(request.paramAsTime("timeout", createIndexRequest.timeout()));
        createIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", createIndexRequest.clusterManagerNodeTimeout()));
        RestCreateIndexAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)createIndexRequest, request, deprecationLogger, this.getName());
        createIndexRequest.waitForActiveShards(ActiveShardCount.parseString((String)request.param("wait_for_active_shards")));
        return channel -> client.admin().indices().create(createIndexRequest, new RestToXContentListener((RestChannel)channel));
    }

    static Map<String, Object> prepareMappings(Map<String, Object> source) {
        if (!source.containsKey("mappings") || !(source.get("mappings") instanceof Map)) {
            return source;
        }
        HashMap<String, Object> newSource = new HashMap<String, Object>(source);
        Map mappings = (Map)source.get("mappings");
        if (MapperService.isMappingSourceTyped((String)"_doc", (Map)mappings)) {
            throw new IllegalArgumentException("The mapping definition cannot be nested under a type");
        }
        newSource.put("mappings", Collections.singletonMap("_doc", mappings));
        return newSource;
    }
}

