/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.get.GetComponentTemplateAction;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetComponentTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetComponentTemplateAction.class);

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_component_template"), new RestHandler.Route(RestRequest.Method.GET, "/_component_template/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_component_template/{name}"));
    }

    @Override
    public String getName() {
        return "get_component_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetComponentTemplateAction.Request getRequest = new GetComponentTemplateAction.Request(request.param("name"));
        getRequest.local(request.paramAsBoolean("local", getRequest.local()));
        getRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRequest.clusterManagerNodeTimeout()));
        RestGetComponentTemplateAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getRequest, request, deprecationLogger, this.getName());
        final boolean implicitAll = getRequest.name() == null;
        return channel -> client.execute((ActionType)GetComponentTemplateAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new RestToXContentListener<GetComponentTemplateAction.Response>(this, channel){

            @Override
            protected RestStatus getStatus(GetComponentTemplateAction.Response response) {
                boolean templateExists = !response.getComponentTemplates().isEmpty();
                return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

