/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.admin.indices.template.put.PutIndexTemplateRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.admin.indices.RestCreateIndexAction;

public class RestPutIndexTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutIndexTemplateAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_template/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_template/{name}")));
    }

    @Override
    public String getName() {
        return "put_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(request.param("name"));
        if (request.hasParam("template")) {
            deprecationLogger.deprecate("put_index_template_deprecated_parameter", "Deprecated parameter [template] used, replaced by [index_patterns]", new Object[0]);
            putRequest.patterns(Collections.singletonList(request.param("template")));
        } else {
            putRequest.patterns(Arrays.asList(request.paramAsStringArray("index_patterns", Strings.EMPTY_ARRAY)));
        }
        putRequest.order(request.paramAsInt("order", putRequest.order()));
        putRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", putRequest.clusterManagerNodeTimeout()));
        RestPutIndexTemplateAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)putRequest, request, deprecationLogger, this.getName());
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", ""));
        Map<String, Object> sourceAsMap = (Map<String, Object>)XContentHelper.convertToMap((BytesReference)request.requiredContent(), (boolean)false, (MediaType)request.getMediaType()).v2();
        sourceAsMap = RestCreateIndexAction.prepareMappings(sourceAsMap);
        putRequest.source(sourceAsMap);
        return channel -> client.admin().indices().putTemplate(putRequest, new RestToXContentListener((RestChannel)channel));
    }
}

