/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.lucenia.action.admin.indices.template.post.SimulateTemplateAction;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestSimulateTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestSimulateTemplateAction.class);

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_index_template/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_index_template/_simulate/{name}"));
    }

    @Override
    public String getName() {
        return "simulate_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SimulateTemplateAction.Request simulateRequest = new SimulateTemplateAction.Request();
        simulateRequest.templateName(request.param("name"));
        if (request.hasContent()) {
            PutComposableIndexTemplateAction.Request indexTemplateRequest = new PutComposableIndexTemplateAction.Request("simulating_template");
            indexTemplateRequest.indexTemplate(ComposableIndexTemplate.parse((XContentParser)request.contentParser()));
            indexTemplateRequest.create(request.paramAsBoolean("create", false));
            indexTemplateRequest.cause(request.param("cause", "api"));
            simulateRequest.indexTemplateRequest(indexTemplateRequest);
        }
        simulateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", simulateRequest.clusterManagerNodeTimeout()));
        RestSimulateTemplateAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)simulateRequest, request, deprecationLogger, this.getName());
        return channel -> client.execute((ActionType)SimulateTemplateAction.INSTANCE, (ActionRequest)simulateRequest, new RestToXContentListener((RestChannel)channel));
    }
}

