/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestAllocationAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestAllocationAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation/{nodes}")));
    }

    @Override
    public String getName() {
        return "cat_allocation_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/allocation\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] nodes = Strings.splitStringByCommaToArray((String)request.param("nodes", "data:true"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().routingTable(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestAllocationAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse state) {
                NodesStatsRequest statsRequest = new NodesStatsRequest(nodes);
                statsRequest.timeout(request.param("timeout"));
                statsRequest.clear().addMetric(NodesStatsRequest.Metric.FS.metricName()).indices(new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.Store}));
                client.admin().cluster().nodesStats(statsRequest, (ActionListener)new RestResponseListener<NodesStatsResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesStatsResponse stats) throws Exception {
                        Table tab = RestAllocationAction.this.buildTable(request, state, stats);
                        return RestTable.buildResponse(tab, this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"shards", "alias:s;text-align:right;desc:number of shards on node");
        table.addCell((Object)"disk.indices", "alias:di,diskIndices;text-align:right;desc:disk used by OpenSearch indices");
        table.addCell((Object)"disk.used", "alias:du,diskUsed;text-align:right;desc:disk used (total, not just OpenSearch)");
        table.addCell((Object)"disk.avail", "alias:da,diskAvail;text-align:right;desc:disk available");
        table.addCell((Object)"disk.total", "alias:dt,diskTotal;text-align:right;desc:total capacity of all volumes");
        table.addCell((Object)"disk.percent", "alias:dp,diskPercent;text-align:right;desc:percent disk used");
        table.addCell((Object)"host", "alias:h;desc:host of node");
        table.addCell((Object)"ip", "desc:ip of node");
        table.addCell((Object)"node", "alias:n;desc:name of node");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state, NodesStatsResponse stats) {
        HashMap<String, Integer> allocs = new HashMap<String, Integer>();
        for (Object shard : state.getState().routingTable().allShards()) {
            String nodeId = "UNASSIGNED";
            if (shard.assignedToNode()) {
                nodeId = shard.currentNodeId();
            }
            allocs.merge(nodeId, 1, Integer::sum);
        }
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : stats.getNodes()) {
            DiscoveryNode node = nodeStats.getNode();
            int shardCount = allocs.getOrDefault(node.getId(), 0);
            ByteSizeValue total = nodeStats.getFs().getTotal().getTotal();
            ByteSizeValue avail = nodeStats.getFs().getTotal().getAvailable();
            long used = 0L;
            short diskPercent = -1;
            if (total.getBytes() > 0L && (used = total.getBytes() - avail.getBytes()) >= 0L && avail.getBytes() >= 0L) {
                diskPercent = (short)(used * 100L / (used + avail.getBytes()));
            }
            table.startRow();
            table.addCell((Object)shardCount);
            table.addCell((Object)nodeStats.getIndices().getStore().getSize());
            table.addCell((Object)(used < 0L ? null : new ByteSizeValue(used)));
            table.addCell((Object)(avail.getBytes() < 0L ? null : avail));
            table.addCell((Object)(total.getBytes() < 0L ? null : total));
            table.addCell((Object)(diskPercent < 0 ? null : Short.valueOf(diskPercent)));
            table.addCell((Object)node.getHostName());
            table.addCell((Object)node.getHostAddress());
            table.addCell((Object)node.getName());
            table.endRow();
        }
        String UNASSIGNED = "UNASSIGNED";
        if (allocs.containsKey("UNASSIGNED")) {
            table.startRow();
            table.addCell(allocs.get("UNASSIGNED"));
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell((Object)"UNASSIGNED");
            table.endRow();
        }
        return table;
    }
}

