/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.recovery.RecoveryRequest;
import io.skylite.core.action.admin.indices.recovery.RecoveryResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.xcontent.XContentLuceniaExtension;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestCatRecoveryAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/recovery"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/recovery/{index}")));
    }

    @Override
    public String getName() {
        return "cat_recovery_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/recovery\n");
        sb.append("/_cat/recovery/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        RecoveryRequest recoveryRequest = new RecoveryRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        recoveryRequest.timeout(request.param("timeout"));
        recoveryRequest.detailed(request.paramAsBoolean("detailed", false));
        recoveryRequest.activeOnly(request.paramAsBoolean("active_only", false));
        recoveryRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)recoveryRequest.indicesOptions()));
        return channel -> client.admin().indices().recoveries(recoveryRequest, (ActionListener)new RestResponseListener<RecoveryResponse>(channel){

            @Override
            public RestResponse buildResponse(RecoveryResponse response) throws Exception {
                return RestTable.buildResponse(RestCatRecoveryAction.this.buildRecoveryTable(request, response), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeaders().addCell((Object)"index", "alias:i,idx;desc:index name").addCell((Object)"shard", "alias:s,sh;desc:shard name").addCell((Object)"start_time", "default:false;alias:start;desc:recovery start time").addCell((Object)"start_time_millis", "default:false;alias:start_millis;desc:recovery start time in epoch milliseconds").addCell((Object)"stop_time", "default:false;alias:stop;desc:recovery stop time").addCell((Object)"stop_time_millis", "default:false;alias:stop_millis;desc:recovery stop time in epoch milliseconds").addCell((Object)"time", "alias:t,ti;desc:recovery time").addCell((Object)"type", "alias:ty;desc:recovery type").addCell((Object)"stage", "alias:st;desc:recovery stage").addCell((Object)"source_host", "alias:shost;desc:source host").addCell((Object)"source_node", "alias:snode;desc:source node name").addCell((Object)"target_host", "alias:thost;desc:target host").addCell((Object)"target_node", "alias:tnode;desc:target node name").addCell((Object)"repository", "alias:rep;desc:repository").addCell((Object)"snapshot", "alias:snap;desc:snapshot").addCell((Object)"files", "alias:f;desc:number of files to recover").addCell((Object)"files_recovered", "alias:fr;desc:files recovered").addCell((Object)"files_percent", "alias:fp;desc:percent of files recovered").addCell((Object)"files_total", "alias:tf;desc:total number of files").addCell((Object)"bytes", "alias:b;desc:number of bytes to recover").addCell((Object)"bytes_recovered", "alias:br;desc:bytes recovered").addCell((Object)"bytes_percent", "alias:bp;desc:percent of bytes recovered").addCell((Object)"bytes_total", "alias:tb;desc:total number of bytes").addCell((Object)"translog_ops", "alias:to;desc:number of translog ops to recover").addCell((Object)"translog_ops_recovered", "alias:tor;desc:translog ops recovered").addCell((Object)"translog_ops_percent", "alias:top;desc:percent of translog ops recovered").endHeaders();
        return t;
    }

    public Table buildRecoveryTable(RestRequest request, RecoveryResponse response) {
        Table t = this.getTableWithHeader(request);
        for (String index : response.shardRecoveryStates().keySet()) {
            List shardRecoveryStates = (List)response.shardRecoveryStates().get(index);
            if (shardRecoveryStates.size() == 0) continue;
            CollectionUtil.introSort((List)shardRecoveryStates, (Comparator)new Comparator<RecoveryState>(this){

                @Override
                public int compare(RecoveryState o1, RecoveryState o2) {
                    int id2;
                    int id1 = o1.getShardId().id();
                    if (id1 < (id2 = o2.getShardId().id())) {
                        return -1;
                    }
                    if (id1 > id2) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (RecoveryState state : shardRecoveryStates) {
                t.startRow();
                t.addCell((Object)index);
                t.addCell((Object)state.getShardId().id());
                t.addCell((Object)XContentLuceniaExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(state.getTimer().startTime())));
                t.addCell((Object)state.getTimer().startTime());
                t.addCell((Object)XContentLuceniaExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(state.getTimer().stopTime())));
                t.addCell((Object)state.getTimer().stopTime());
                t.addCell((Object)new TimeValue(state.getTimer().time()));
                t.addCell((Object)state.getRecoverySource().getType().toString().toLowerCase(Locale.ROOT));
                t.addCell((Object)state.getStage().toString().toLowerCase(Locale.ROOT));
                t.addCell((Object)(state.getSourceNode() == null ? "n/a" : state.getSourceNode().getHostName()));
                t.addCell((Object)(state.getSourceNode() == null ? "n/a" : state.getSourceNode().getName()));
                t.addCell((Object)state.getTargetNode().getHostName());
                t.addCell((Object)state.getTargetNode().getName());
                t.addCell((Object)(state.getRecoverySource() == null || state.getRecoverySource().getType() != RecoverySource.Type.SNAPSHOT ? "n/a" : ((RecoverySource.SnapshotRecoverySource)state.getRecoverySource()).snapshot().getRepository()));
                t.addCell((Object)(state.getRecoverySource() == null || state.getRecoverySource().getType() != RecoverySource.Type.SNAPSHOT ? "n/a" : ((RecoverySource.SnapshotRecoverySource)state.getRecoverySource()).snapshot().getSnapshotId().getName()));
                t.addCell((Object)state.getIndex().totalRecoverFiles());
                t.addCell((Object)state.getIndex().recoveredFileCount());
                t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredFilesPercent())));
                t.addCell((Object)state.getIndex().totalFileCount());
                t.addCell((Object)state.getIndex().totalRecoverBytes());
                t.addCell((Object)state.getIndex().recoveredBytes());
                t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredBytesPercent())));
                t.addCell((Object)state.getIndex().totalBytes());
                t.addCell((Object)state.getTranslog().totalOperations());
                t.addCell((Object)state.getTranslog().recoveredOperations());
                t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getTranslog().recoveredPercent())));
                t.endRow();
            }
        }
        return t;
    }
}

