/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationStatsRequest;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationStatsResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.SegmentReplicationPerGroupStats;
import io.skylite.core.index.SegmentReplicationShardStats;
import io.skylite.core.indices.replication.SegmentReplicationState;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.xcontent.XContentLuceniaExtension;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestCatSegmentReplicationAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/segment_replication"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/segment_replication/{index}")));
    }

    @Override
    public String getName() {
        return "cat_segment_replication_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/segment_replication\n");
        sb.append("/_cat/segment_replication/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        SegmentReplicationStatsRequest segmentReplicationStatsRequest = new SegmentReplicationStatsRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        segmentReplicationStatsRequest.timeout(request.param("timeout"));
        segmentReplicationStatsRequest.detailed(request.paramAsBoolean("detailed", false));
        segmentReplicationStatsRequest.shards(Strings.splitStringByCommaToArray((String)request.param("shards")));
        segmentReplicationStatsRequest.activeOnly(request.paramAsBoolean("active_only", false));
        segmentReplicationStatsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)segmentReplicationStatsRequest.indicesOptions()));
        return channel -> client.admin().indices().segmentReplicationStats(segmentReplicationStatsRequest, (ActionListener)new RestResponseListener<SegmentReplicationStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(SegmentReplicationStatsResponse response) throws Exception {
                return RestTable.buildResponse(RestCatSegmentReplicationAction.this.buildSegmentReplicationTable(request, response), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        boolean detailed = false;
        if (request != null) {
            detailed = Boolean.parseBoolean(request.param("detailed"));
        }
        Table t = new Table();
        t.startHeaders().addCell((Object)"shardId", "alias:s;desc: shard Id").addCell((Object)"target_node", "alias:tnode;desc:target node name").addCell((Object)"target_host", "alias:thost;desc:target host").addCell((Object)"checkpoints_behind", "alias:cpb;desc:checkpoints behind primary").addCell((Object)"bytes_behind", "alias:bb;desc:bytes behind primary").addCell((Object)"current_lag", "alias:clag;desc:ongoing time elapsed waiting for replica to catch up to primary").addCell((Object)"last_completed_lag", "alias:lcl;desc:time taken for replica to catch up to latest primary refresh").addCell((Object)"rejected_requests", "alias:rr;desc:count of rejected requests for the replication group");
        if (detailed) {
            t.addCell((Object)"stage", "alias:st;desc:segment replication event stage").addCell((Object)"time", "alias:t,ti;desc:current replication event time").addCell((Object)"files_fetched", "alias:ff;desc:files fetched").addCell((Object)"files_percent", "alias:fp;desc:percent of files fetched").addCell((Object)"bytes_fetched", "alias:bf;desc:bytes fetched").addCell((Object)"bytes_percent", "alias:bp;desc:percent of bytes fetched").addCell((Object)"start_time", "alias:start;desc:segment replication start time").addCell((Object)"stop_time", "alias:stop;desc:segment replication stop time").addCell((Object)"files", "alias:f;desc:number of files to fetch").addCell((Object)"files_total", "alias:tf;desc:total number of files").addCell((Object)"bytes", "alias:b;desc:number of bytes to fetch").addCell((Object)"bytes_total", "alias:tb;desc:total number of bytes").addCell((Object)"replicating_stage_time_taken", "alias:rstt;desc:time taken in replicating stage").addCell((Object)"get_checkpoint_info_stage_time_taken", "alias:gcistt;desc:time taken in get checkpoint info stage").addCell((Object)"file_diff_stage_time_taken", "alias:fdstt;desc:time taken in file diff stage").addCell((Object)"get_files_stage_time_taken", "alias:gfstt;desc:time taken in get files stage").addCell((Object)"finalize_replication_stage_time_taken", "alias:frstt;desc:time taken in finalize replication stage");
        }
        t.endHeaders();
        return t;
    }

    public Table buildSegmentReplicationTable(RestRequest request, SegmentReplicationStatsResponse response) {
        boolean detailed = false;
        if (request != null) {
            detailed = Boolean.parseBoolean(request.param("detailed"));
        }
        Table t = this.getTableWithHeader(request);
        for (Map.Entry entry : response.getReplicationStats().entrySet()) {
            List replicationPerGroupStats = (List)entry.getValue();
            if (replicationPerGroupStats.isEmpty()) continue;
            CollectionUtil.introSort((List)replicationPerGroupStats, (o1, o2) -> {
                int id1 = o1.getShardId().id();
                int id2 = o2.getShardId().id();
                return Integer.compare(id1, id2);
            });
            for (SegmentReplicationPerGroupStats perGroupStats : replicationPerGroupStats) {
                Set replicaShardStats = perGroupStats.getReplicaStats();
                for (SegmentReplicationShardStats shardStats : replicaShardStats) {
                    SegmentReplicationState state = shardStats.getCurrentReplicationState();
                    if (state == null) continue;
                    t.startRow();
                    t.addCell((Object)perGroupStats.getShardId());
                    t.addCell((Object)state.getTargetNode().getName());
                    t.addCell((Object)state.getTargetNode().getHostName());
                    t.addCell((Object)shardStats.getCheckpointsBehindCount());
                    t.addCell((Object)new ByteSizeValue(shardStats.getBytesBehindCount()));
                    t.addCell((Object)new TimeValue(shardStats.getCurrentReplicationLagMillis()));
                    t.addCell((Object)new TimeValue(shardStats.getLastCompletedReplicationTimeMillis()));
                    t.addCell((Object)perGroupStats.getRejectedRequestCount());
                    if (detailed) {
                        t.addCell((Object)state.getStage().toString().toLowerCase(Locale.ROOT));
                        t.addCell((Object)new TimeValue(state.getTimer().time()));
                        t.addCell((Object)state.getIndex().recoveredFileCount());
                        t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredFilesPercent())));
                        t.addCell((Object)state.getIndex().recoveredBytes());
                        t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredBytesPercent())));
                        t.addCell((Object)XContentLuceniaExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(state.getTimer().startTime())));
                        t.addCell((Object)XContentLuceniaExtension.DEFAULT_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(state.getTimer().stopTime())));
                        t.addCell((Object)state.getIndex().totalRecoverFiles());
                        t.addCell((Object)state.getIndex().totalFileCount());
                        t.addCell((Object)new ByteSizeValue(state.getIndex().totalRecoverBytes()));
                        t.addCell((Object)new ByteSizeValue(state.getIndex().totalBytes()));
                        t.addCell((Object)state.getReplicatingStageTime());
                        t.addCell((Object)state.getGetCheckpointInfoStageTime());
                        t.addCell((Object)state.getFileDiffStageTime());
                        t.addCell((Object)state.getGetFileStageTime());
                        t.addCell((Object)state.getFinalizeReplicationStageTime());
                    }
                    t.endRow();
                }
            }
        }
        return t;
    }
}

