/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.TotalHits;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestCountAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/count"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/count/{index}")));
    }

    @Override
    public String getName() {
        return "cat_count_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/count\n");
        sb.append("/_cat/count/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        SearchRequest countRequest = new SearchRequest(indices);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).trackTotalHits(true);
        countRequest.source(searchSourceBuilder);
        try {
            request.withContentOrSourceParamParserOrNull(parser -> {
                if (parser == null) {
                    QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
                    if (queryBuilder != null) {
                        searchSourceBuilder.query(queryBuilder);
                    }
                } else {
                    searchSourceBuilder.query(RestActions.getQueryContent(parser));
                }
            });
        }
        catch (IOException e) {
            throw new SkyliteException("Couldn't parse query", (Throwable)e, new Object[0]);
        }
        return channel -> client.search(countRequest, (ActionListener)new RestResponseListener<SearchResponse>(channel){

            @Override
            public RestResponse buildResponse(SearchResponse countResponse) throws Exception {
                assert (countResponse.getHits().getTotalHits().relation() == TotalHits.Relation.EQUAL_TO);
                return RestTable.buildResponse(RestCountAction.this.buildTable(request, countResponse), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeadersWithTimestamp();
        table.addCell((Object)"count", "alias:dc,docs.count,docsCount;desc:the document count");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, SearchResponse response) {
        Table table = this.getTableWithHeader(request);
        table.startRow();
        table.addCell((Object)response.getHits().getTotalHits().value());
        table.endRow();
        return table;
    }
}

