/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Table;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestHealthAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/health"));
    }

    @Override
    public String getName() {
        return "cat_health_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/health\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest();
        return channel -> client.admin().cluster().health(clusterHealthRequest, (ActionListener)new RestResponseListener<ClusterHealthResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterHealthResponse health) throws Exception {
                return RestTable.buildResponse(RestHealthAction.this.buildTable(health, request), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeadersWithTimestamp();
        t.addCell((Object)"cluster", "alias:cl;desc:cluster name");
        t.addCell((Object)"status", "alias:st;desc:health status");
        t.addCell((Object)"node.total", "alias:nt,nodeTotal;text-align:right;desc:total number of nodes");
        t.addCell((Object)"node.data", "alias:nd,nodeData;text-align:right;desc:number of nodes that can store data");
        t.addCell((Object)"discovered_cluster_manager", "alias:dcm,dm,discovered_master;text-align:right;desc:cluster manager is discovered or not");
        t.addCell((Object)"shards", "alias:t,sh,shards.total,shardsTotal;text-align:right;desc:total number of shards");
        t.addCell((Object)"pri", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        t.addCell((Object)"relo", "alias:r,shards.relocating,shardsRelocating;text-align:right;desc:number of relocating nodes");
        t.addCell((Object)"init", "alias:i,shards.initializing,shardsInitializing;text-align:right;desc:number of initializing nodes");
        t.addCell((Object)"unassign", "alias:u,shards.unassigned,shardsUnassigned;text-align:right;desc:number of unassigned shards");
        t.addCell((Object)"pending_tasks", "alias:pt,pendingTasks;text-align:right;desc:number of pending tasks");
        t.addCell((Object)"max_task_wait_time", "alias:mtwt,maxTaskWaitTime;text-align:right;desc:wait time of longest task pending");
        t.addCell((Object)"active_shards_percent", "alias:asp,activeShardsPercent;text-align:right;desc:active number of shards in percent");
        t.endHeaders();
        return t;
    }

    private Table buildTable(ClusterHealthResponse health, RestRequest request) {
        Table t = this.getTableWithHeader(request);
        t.startRow();
        t.addCell((Object)health.getClusterName());
        t.addCell((Object)health.getStatus().name().toLowerCase(Locale.ROOT));
        t.addCell((Object)health.getNumberOfNodes());
        t.addCell((Object)health.getNumberOfDataNodes());
        t.addCell((Object)health.hasDiscoveredClusterManager());
        t.addCell((Object)health.getActiveShards());
        t.addCell((Object)health.getActivePrimaryShards());
        t.addCell((Object)health.getRelocatingShards());
        t.addCell((Object)health.getInitializingShards());
        t.addCell((Object)health.getUnassignedShards());
        t.addCell((Object)health.getNumberOfPendingTasks());
        t.addCell((Object)(health.getTaskMaxWaitingTime().millis() == 0L ? "-" : health.getTaskMaxWaitingTime()));
        t.addCell((Object)String.format(Locale.ROOT, "%1.1f%%", health.getActiveShardsPercent()));
        t.endRow();
        return t;
    }
}

