/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.SkyliteParseException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthResponse;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.settings.get.GetSettingsRequest;
import io.skylite.core.action.admin.indices.settings.get.GetSettingsResponse;
import io.skylite.core.action.admin.indices.stats.CommonStats;
import io.skylite.core.action.admin.indices.stats.IndexStats;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.health.ClusterIndexHealth;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.settings.Settings;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestIndicesAction
extends AbstractCatAction {
    private static final DateFormatter STRICT_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"strict_date_time");
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestIndicesAction.class);
    private static final String MASTER_TIMEOUT_DEPRECATED_MESSAGE = "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.";
    private static final String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";
    private static final Set<String> RESPONSE_PARAMS;

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/indices"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/indices/{index}")));
    }

    @Override
    public String getName() {
        return "cat_indices_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/indices\n");
        sb.append("/_cat/indices/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)IndicesOptions.strictExpand());
        final boolean local = request.paramAsBoolean("local", false);
        TimeValue clusterManagerTimeout = request.paramAsTime("cluster_manager_timeout", ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        if (request.hasParam("master_timeout")) {
            deprecationLogger.deprecate("cat_indices_master_timeout_parameter", MASTER_TIMEOUT_DEPRECATED_MESSAGE, new Object[0]);
            if (request.hasParam("cluster_manager_timeout")) {
                throw new SkyliteParseException(DUPLICATE_PARAMETER_ERROR_MESSAGE, new Object[0]);
            }
            clusterManagerTimeout = request.paramAsTime("master_timeout", ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        }
        final TimeValue clusterManagerNodeTimeout = clusterManagerTimeout;
        final boolean includeUnloadedSegments = request.paramAsBoolean("include_unloaded_segments", false);
        return channel -> {
            final ActionListener listener = ActionListenerHelper.notifyOnce((ActionListener)new RestResponseListener<Table>(this, channel){

                @Override
                public RestResponse buildResponse(Table table) throws Exception {
                    return RestTable.buildResponse(table, this.channel);
                }
            });
            this.sendGetSettingsRequest(indices, indicesOptions, local, clusterManagerNodeTimeout, client, new ActionListener<GetSettingsResponse>(){

                public void onResponse(GetSettingsResponse getSettingsResponse) {
                    GroupedActionListener<ActionResponse> groupedListener = RestIndicesAction.this.createGroupedListener(request, 4, (ActionListener<Table>)listener);
                    groupedListener.onResponse((Object)getSettingsResponse);
                    IndicesOptions subRequestIndicesOptions = IndicesOptions.lenientExpandHidden();
                    RestIndicesAction.this.sendIndicesStatsRequest(indices, subRequestIndicesOptions, includeUnloadedSegments, client, (ActionListener<IndicesStatsResponse>)ActionListenerHelper.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                    RestIndicesAction.this.sendClusterStateRequest(indices, subRequestIndicesOptions, local, clusterManagerNodeTimeout, client, (ActionListener<ClusterStateResponse>)ActionListenerHelper.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                    RestIndicesAction.this.sendClusterHealthRequest(indices, subRequestIndicesOptions, local, clusterManagerNodeTimeout, client, (ActionListener<ClusterHealthResponse>)ActionListenerHelper.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        };
    }

    private void sendGetSettingsRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, NodeClient client, ActionListener<GetSettingsResponse> listener) {
        GetSettingsRequest request = new GetSettingsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        request.names(new String[]{IndexSettings.INDEX_SEARCH_THROTTLED.getKey()});
        client.admin().indices().getSettings(request, listener);
    }

    private void sendClusterStateRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, NodeClient client, ActionListener<ClusterStateResponse> listener) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        client.admin().cluster().state(request, listener);
    }

    private void sendClusterHealthRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, NodeClient client, ActionListener<ClusterHealthResponse> listener) {
        ClusterHealthRequest request = new ClusterHealthRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        client.admin().cluster().health(request, listener);
    }

    private void sendIndicesStatsRequest(String[] indices, IndicesOptions indicesOptions, boolean includeUnloadedSegments, NodeClient client, ActionListener<IndicesStatsResponse> listener) {
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.all();
        request.includeUnloadedSegments(includeUnloadedSegments);
        client.admin().indices().stats(request, listener);
    }

    private GroupedActionListener<ActionResponse> createGroupedListener(final RestRequest request, int size, final ActionListener<Table> listener) {
        return new GroupedActionListener((ActionListener)new ActionListener<Collection<ActionResponse>>(){

            public void onResponse(Collection<ActionResponse> responses) {
                try {
                    GetSettingsResponse settingsResponse = RestIndicesAction.extractResponse(responses, GetSettingsResponse.class);
                    Map<String, Settings> indicesSettings = StreamSupport.stream(Spliterators.spliterator(settingsResponse.getIndexToSettings().entrySet(), 0), false).collect(Collectors.toMap(cursor -> (String)cursor.getKey(), cursor -> (Settings)cursor.getValue()));
                    ClusterStateResponse stateResponse = RestIndicesAction.extractResponse(responses, ClusterStateResponse.class);
                    Map<String, IndexMetadata> indicesStates = StreamSupport.stream(stateResponse.getState().getMetadata().spliterator(), false).collect(Collectors.toMap(indexMetadata -> indexMetadata.getIndex().getName(), Function.identity()));
                    ClusterHealthResponse healthResponse = RestIndicesAction.extractResponse(responses, ClusterHealthResponse.class);
                    Map indicesHealths = healthResponse.getIndices();
                    IndicesStatsResponse statsResponse = RestIndicesAction.extractResponse(responses, IndicesStatsResponse.class);
                    Map indicesStats = statsResponse.getIndices();
                    Table responseTable = RestIndicesAction.this.buildTable(request, indicesSettings, indicesHealths, indicesStats, indicesStates);
                    listener.onResponse((Object)responseTable);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, size);
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"health", "alias:h;desc:current health status");
        table.addCell((Object)"status", "alias:s;desc:open/close status");
        table.addCell((Object)"index", "alias:i,idx;desc:index name");
        table.addCell((Object)"uuid", "alias:id,uuid;desc:index uuid");
        table.addCell((Object)"pri", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        table.addCell((Object)"rep", "alias:r,shards.replica,shardsReplica;text-align:right;desc:number of replica shards");
        table.addCell((Object)"docs.count", "alias:dc,docsCount;text-align:right;desc:available docs");
        table.addCell((Object)"docs.deleted", "alias:dd,docsDeleted;text-align:right;desc:deleted docs");
        table.addCell((Object)"creation.date", "alias:cd;default:false;desc:index creation date (millisecond value)");
        table.addCell((Object)"creation.date.string", "alias:cds;default:false;desc:index creation date (as string)");
        table.addCell((Object)"store.size", "sibling:pri;alias:ss,storeSize;text-align:right;desc:store size of primaries & replicas");
        table.addCell((Object)"pri.store.size", "text-align:right;desc:store size of primaries");
        table.addCell((Object)"completion.size", "sibling:pri;alias:cs,completionSize;default:false;text-align:right;desc:size of completion");
        table.addCell((Object)"pri.completion.size", "default:false;text-align:right;desc:size of completion");
        table.addCell((Object)"fielddata.memory_size", "sibling:pri;alias:fm,fielddataMemory;default:false;text-align:right;desc:used fielddata cache");
        table.addCell((Object)"pri.fielddata.memory_size", "default:false;text-align:right;desc:used fielddata cache");
        table.addCell((Object)"fielddata.evictions", "sibling:pri;alias:fe,fielddataEvictions;default:false;text-align:right;desc:fielddata evictions");
        table.addCell((Object)"pri.fielddata.evictions", "default:false;text-align:right;desc:fielddata evictions");
        table.addCell((Object)"query_cache.memory_size", "sibling:pri;alias:qcm,queryCacheMemory;default:false;text-align:right;desc:used query cache");
        table.addCell((Object)"pri.query_cache.memory_size", "default:false;text-align:right;desc:used query cache");
        table.addCell((Object)"query_cache.evictions", "sibling:pri;alias:qce,queryCacheEvictions;default:false;text-align:right;desc:query cache evictions");
        table.addCell((Object)"pri.query_cache.evictions", "default:false;text-align:right;desc:query cache evictions");
        table.addCell((Object)"request_cache.memory_size", "sibling:pri;alias:rcm,requestCacheMemory;default:false;text-align:right;desc:used request cache");
        table.addCell((Object)"pri.request_cache.memory_size", "default:false;text-align:right;desc:used request cache");
        table.addCell((Object)"request_cache.evictions", "sibling:pri;alias:rce,requestCacheEvictions;default:false;text-align:right;desc:request cache evictions");
        table.addCell((Object)"pri.request_cache.evictions", "default:false;text-align:right;desc:request cache evictions");
        table.addCell((Object)"request_cache.hit_count", "sibling:pri;alias:rchc,requestCacheHitCount;default:false;text-align:right;desc:request cache hit count");
        table.addCell((Object)"pri.request_cache.hit_count", "default:false;text-align:right;desc:request cache hit count");
        table.addCell((Object)"request_cache.miss_count", "sibling:pri;alias:rcmc,requestCacheMissCount;default:false;text-align:right;desc:request cache miss count");
        table.addCell((Object)"pri.request_cache.miss_count", "default:false;text-align:right;desc:request cache miss count");
        table.addCell((Object)"flush.total", "sibling:pri;alias:ft,flushTotal;default:false;text-align:right;desc:number of flushes");
        table.addCell((Object)"pri.flush.total", "default:false;text-align:right;desc:number of flushes");
        table.addCell((Object)"flush.total_time", "sibling:pri;alias:ftt,flushTotalTime;default:false;text-align:right;desc:time spent in flush");
        table.addCell((Object)"pri.flush.total_time", "default:false;text-align:right;desc:time spent in flush");
        table.addCell((Object)"get.current", "sibling:pri;alias:gc,getCurrent;default:false;text-align:right;desc:number of current get ops");
        table.addCell((Object)"pri.get.current", "default:false;text-align:right;desc:number of current get ops");
        table.addCell((Object)"get.time", "sibling:pri;alias:gti,getTime;default:false;text-align:right;desc:time spent in get");
        table.addCell((Object)"pri.get.time", "default:false;text-align:right;desc:time spent in get");
        table.addCell((Object)"get.total", "sibling:pri;alias:gto,getTotal;default:false;text-align:right;desc:number of get ops");
        table.addCell((Object)"pri.get.total", "default:false;text-align:right;desc:number of get ops");
        table.addCell((Object)"get.exists_time", "sibling:pri;alias:geti,getExistsTime;default:false;text-align:right;desc:time spent in successful gets");
        table.addCell((Object)"pri.get.exists_time", "default:false;text-align:right;desc:time spent in successful gets");
        table.addCell((Object)"get.exists_total", "sibling:pri;alias:geto,getExistsTotal;default:false;text-align:right;desc:number of successful gets");
        table.addCell((Object)"pri.get.exists_total", "default:false;text-align:right;desc:number of successful gets");
        table.addCell((Object)"get.missing_time", "sibling:pri;alias:gmti,getMissingTime;default:false;text-align:right;desc:time spent in failed gets");
        table.addCell((Object)"pri.get.missing_time", "default:false;text-align:right;desc:time spent in failed gets");
        table.addCell((Object)"get.missing_total", "sibling:pri;alias:gmto,getMissingTotal;default:false;text-align:right;desc:number of failed gets");
        table.addCell((Object)"pri.get.missing_total", "default:false;text-align:right;desc:number of failed gets");
        table.addCell((Object)"indexing.delete_current", "sibling:pri;alias:idc,indexingDeleteCurrent;default:false;text-align:right;desc:number of current deletions");
        table.addCell((Object)"pri.indexing.delete_current", "default:false;text-align:right;desc:number of current deletions");
        table.addCell((Object)"indexing.delete_time", "sibling:pri;alias:idti,indexingDeleteTime;default:false;text-align:right;desc:time spent in deletions");
        table.addCell((Object)"pri.indexing.delete_time", "default:false;text-align:right;desc:time spent in deletions");
        table.addCell((Object)"indexing.delete_total", "sibling:pri;alias:idto,indexingDeleteTotal;default:false;text-align:right;desc:number of delete ops");
        table.addCell((Object)"pri.indexing.delete_total", "default:false;text-align:right;desc:number of delete ops");
        table.addCell((Object)"indexing.index_current", "sibling:pri;alias:iic,indexingIndexCurrent;default:false;text-align:right;desc:number of current indexing ops");
        table.addCell((Object)"pri.indexing.index_current", "default:false;text-align:right;desc:number of current indexing ops");
        table.addCell((Object)"indexing.index_time", "sibling:pri;alias:iiti,indexingIndexTime;default:false;text-align:right;desc:time spent in indexing");
        table.addCell((Object)"pri.indexing.index_time", "default:false;text-align:right;desc:time spent in indexing");
        table.addCell((Object)"indexing.index_total", "sibling:pri;alias:iito,indexingIndexTotal;default:false;text-align:right;desc:number of indexing ops");
        table.addCell((Object)"pri.indexing.index_total", "default:false;text-align:right;desc:number of indexing ops");
        table.addCell((Object)"indexing.index_failed", "sibling:pri;alias:iif,indexingIndexFailed;default:false;text-align:right;desc:number of failed indexing ops");
        table.addCell((Object)"pri.indexing.index_failed", "default:false;text-align:right;desc:number of failed indexing ops");
        table.addCell((Object)"merges.current", "sibling:pri;alias:mc,mergesCurrent;default:false;text-align:right;desc:number of current merges");
        table.addCell((Object)"pri.merges.current", "default:false;text-align:right;desc:number of current merges");
        table.addCell((Object)"merges.current_docs", "sibling:pri;alias:mcd,mergesCurrentDocs;default:false;text-align:right;desc:number of current merging docs");
        table.addCell((Object)"pri.merges.current_docs", "default:false;text-align:right;desc:number of current merging docs");
        table.addCell((Object)"merges.current_size", "sibling:pri;alias:mcs,mergesCurrentSize;default:false;text-align:right;desc:size of current merges");
        table.addCell((Object)"pri.merges.current_size", "default:false;text-align:right;desc:size of current merges");
        table.addCell((Object)"merges.total", "sibling:pri;alias:mt,mergesTotal;default:false;text-align:right;desc:number of completed merge ops");
        table.addCell((Object)"pri.merges.total", "default:false;text-align:right;desc:number of completed merge ops");
        table.addCell((Object)"merges.total_docs", "sibling:pri;alias:mtd,mergesTotalDocs;default:false;text-align:right;desc:docs merged");
        table.addCell((Object)"pri.merges.total_docs", "default:false;text-align:right;desc:docs merged");
        table.addCell((Object)"merges.total_size", "sibling:pri;alias:mts,mergesTotalSize;default:false;text-align:right;desc:size merged");
        table.addCell((Object)"pri.merges.total_size", "default:false;text-align:right;desc:size merged");
        table.addCell((Object)"merges.total_time", "sibling:pri;alias:mtt,mergesTotalTime;default:false;text-align:right;desc:time spent in merges");
        table.addCell((Object)"pri.merges.total_time", "default:false;text-align:right;desc:time spent in merges");
        table.addCell((Object)"refresh.total", "sibling:pri;alias:rto,refreshTotal;default:false;text-align:right;desc:total refreshes");
        table.addCell((Object)"pri.refresh.total", "default:false;text-align:right;desc:total refreshes");
        table.addCell((Object)"refresh.time", "sibling:pri;alias:rti,refreshTime;default:false;text-align:right;desc:time spent in refreshes");
        table.addCell((Object)"pri.refresh.time", "default:false;text-align:right;desc:time spent in refreshes");
        table.addCell((Object)"refresh.external_total", "sibling:pri;alias:rto,refreshTotal;default:false;text-align:right;desc:total external refreshes");
        table.addCell((Object)"pri.refresh.external_total", "default:false;text-align:right;desc:total external refreshes");
        table.addCell((Object)"refresh.external_time", "sibling:pri;alias:rti,refreshTime;default:false;text-align:right;desc:time spent in external refreshes");
        table.addCell((Object)"pri.refresh.external_time", "default:false;text-align:right;desc:time spent in external refreshes");
        table.addCell((Object)"refresh.listeners", "sibling:pri;alias:rli,refreshListeners;default:false;text-align:right;desc:number of pending refresh listeners");
        table.addCell((Object)"pri.refresh.listeners", "default:false;text-align:right;desc:number of pending refresh listeners");
        table.addCell((Object)"search.fetch_current", "sibling:pri;alias:sfc,searchFetchCurrent;default:false;text-align:right;desc:current fetch phase ops");
        table.addCell((Object)"pri.search.fetch_current", "default:false;text-align:right;desc:current fetch phase ops");
        table.addCell((Object)"search.fetch_time", "sibling:pri;alias:sfti,searchFetchTime;default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell((Object)"pri.search.fetch_time", "default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell((Object)"search.fetch_total", "sibling:pri;alias:sfto,searchFetchTotal;default:false;text-align:right;desc:total fetch ops");
        table.addCell((Object)"pri.search.fetch_total", "default:false;text-align:right;desc:total fetch ops");
        table.addCell((Object)"search.open_contexts", "sibling:pri;alias:so,searchOpenContexts;default:false;text-align:right;desc:open search contexts");
        table.addCell((Object)"pri.search.open_contexts", "default:false;text-align:right;desc:open search contexts");
        table.addCell((Object)"search.query_current", "sibling:pri;alias:sqc,searchQueryCurrent;default:false;text-align:right;desc:current query phase ops");
        table.addCell((Object)"pri.search.query_current", "default:false;text-align:right;desc:current query phase ops");
        table.addCell((Object)"search.query_time", "sibling:pri;alias:sqti,searchQueryTime;default:false;text-align:right;desc:time spent in query phase");
        table.addCell((Object)"pri.search.query_time", "default:false;text-align:right;desc:time spent in query phase");
        table.addCell((Object)"search.query_total", "sibling:pri;alias:sqto,searchQueryTotal;default:false;text-align:right;desc:total query phase ops");
        table.addCell((Object)"pri.search.query_total", "default:false;text-align:right;desc:total query phase ops");
        if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
            table.addCell((Object)"search.concurrent_query_current", "sibling:pri;alias:scqc,searchConcurrentQueryCurrent;default:false;text-align:right;desc:current concurrent query phase ops");
            table.addCell((Object)"pri.search.concurrent_query_current", "default:false;text-align:right;desc:current concurrent query phase ops");
            table.addCell((Object)"search.concurrent_query_time", "sibling:pri;alias:scqti,searchConcurrentQueryTime;default:false;text-align:right;desc:time spent in concurrent query phase");
            table.addCell((Object)"pri.search.concurrent_query_time", "default:false;text-align:right;desc:time spent in concurrent query phase");
            table.addCell((Object)"search.concurrent_query_total", "sibling:pri;alias:scqto,searchConcurrentQueryTotal;default:false;text-align:right;desc:total query phase ops");
            table.addCell((Object)"pri.search.concurrent_query_total", "default:false;text-align:right;desc:total query phase ops");
            table.addCell((Object)"search.concurrent_avg_slice_count", "sibling:pri;alias:casc,searchConcurrentAvgSliceCount;default:false;text-align:right;desc:average query concurrency");
            table.addCell((Object)"pri.search.concurrent_avg_slice_count", "default:false;text-align:right;desc:average query concurrency");
        }
        table.addCell((Object)"search.scroll_current", "sibling:pri;alias:scc,searchScrollCurrent;default:false;text-align:right;desc:open scroll contexts");
        table.addCell((Object)"pri.search.scroll_current", "default:false;text-align:right;desc:open scroll contexts");
        table.addCell((Object)"search.scroll_time", "sibling:pri;alias:scti,searchScrollTime;default:false;text-align:right;desc:time scroll contexts held open");
        table.addCell((Object)"pri.search.scroll_time", "default:false;text-align:right;desc:time scroll contexts held open");
        table.addCell((Object)"search.scroll_total", "sibling:pri;alias:scto,searchScrollTotal;default:false;text-align:right;desc:completed scroll contexts");
        table.addCell((Object)"pri.search.scroll_total", "default:false;text-align:right;desc:completed scroll contexts");
        table.addCell((Object)"search.point_in_time_current", "sibling:pri;alias:scc,searchPointInTimeCurrent;default:false;text-align:right;desc:open point in time contexts");
        table.addCell((Object)"pri.search.point_in_time_current", "default:false;text-align:right;desc:open point in time contexts");
        table.addCell((Object)"search.point_in_time_time", "sibling:pri;alias:scti,searchPointInTimeTime;default:false;text-align:right;desc:time point in time contexts held open");
        table.addCell((Object)"pri.search.point_in_time_time", "default:false;text-align:right;desc:time point in time contexts held open");
        table.addCell((Object)"search.point_in_time_total", "sibling:pri;alias:scto,searchPointInTimeTotal;default:false;text-align:right;desc:completed point in time contexts");
        table.addCell((Object)"pri.search.point_in_time_total", "default:false;text-align:right;desc:completed point in time contexts");
        table.addCell((Object)"segments.count", "sibling:pri;alias:sc,segmentsCount;default:false;text-align:right;desc:number of segments");
        table.addCell((Object)"pri.segments.count", "default:false;text-align:right;desc:number of segments");
        table.addCell((Object)"segments.memory", "sibling:pri;alias:sm,segmentsMemory;default:false;text-align:right;desc:memory used by segments");
        table.addCell((Object)"pri.segments.memory", "default:false;text-align:right;desc:memory used by segments");
        table.addCell((Object)"segments.index_writer_memory", "sibling:pri;alias:siwm,segmentsIndexWriterMemory;default:false;text-align:right;desc:memory used by index writer");
        table.addCell((Object)"pri.segments.index_writer_memory", "default:false;text-align:right;desc:memory used by index writer");
        table.addCell((Object)"segments.version_map_memory", "sibling:pri;alias:svmm,segmentsVersionMapMemory;default:false;text-align:right;desc:memory used by version map");
        table.addCell((Object)"pri.segments.version_map_memory", "default:false;text-align:right;desc:memory used by version map");
        table.addCell((Object)"segments.fixed_bitset_memory", "sibling:pri;alias:sfbm,fixedBitsetMemory;default:false;text-align:right;desc:memory used by fixed bit sets for nested object field types and type filters for types referred in _parent fields");
        table.addCell((Object)"pri.segments.fixed_bitset_memory", "default:false;text-align:right;desc:memory used by fixed bit sets for nested object field types and type filters for types referred in _parent fields");
        table.addCell((Object)"warmer.current", "sibling:pri;alias:wc,warmerCurrent;default:false;text-align:right;desc:current warmer ops");
        table.addCell((Object)"pri.warmer.current", "default:false;text-align:right;desc:current warmer ops");
        table.addCell((Object)"warmer.total", "sibling:pri;alias:wto,warmerTotal;default:false;text-align:right;desc:total warmer ops");
        table.addCell((Object)"pri.warmer.total", "default:false;text-align:right;desc:total warmer ops");
        table.addCell((Object)"warmer.total_time", "sibling:pri;alias:wtt,warmerTotalTime;default:false;text-align:right;desc:time spent in warmers");
        table.addCell((Object)"pri.warmer.total_time", "default:false;text-align:right;desc:time spent in warmers");
        table.addCell((Object)"suggest.current", "sibling:pri;alias:suc,suggestCurrent;default:false;text-align:right;desc:number of current suggest ops");
        table.addCell((Object)"pri.suggest.current", "default:false;text-align:right;desc:number of current suggest ops");
        table.addCell((Object)"suggest.time", "sibling:pri;alias:suti,suggestTime;default:false;text-align:right;desc:time spend in suggest");
        table.addCell((Object)"pri.suggest.time", "default:false;text-align:right;desc:time spend in suggest");
        table.addCell((Object)"suggest.total", "sibling:pri;alias:suto,suggestTotal;default:false;text-align:right;desc:number of suggest ops");
        table.addCell((Object)"pri.suggest.total", "default:false;text-align:right;desc:number of suggest ops");
        table.addCell((Object)"memory.total", "sibling:pri;alias:tm,memoryTotal;default:false;text-align:right;desc:total used memory");
        table.addCell((Object)"pri.memory.total", "default:false;text-align:right;desc:total user memory");
        table.addCell((Object)"search.throttled", "alias:sth;default:false;desc:indicates if the index is search throttled");
        table.endHeaders();
        return table;
    }

    Table buildTable(RestRequest request, Map<String, Settings> indicesSettings, Map<String, ClusterIndexHealth> indicesHealths, Map<String, IndexStats> indicesStats, Map<String, IndexMetadata> indicesMetadatas) {
        String healthParam = request.param("health");
        Table table = this.getTableWithHeader(request);
        indicesSettings.forEach((indexName, settings) -> {
            CommonStats totalStats;
            CommonStats primaryStats;
            if (!indicesMetadatas.containsKey(indexName)) {
                return;
            }
            IndexMetadata indexMetadata = (IndexMetadata)indicesMetadatas.get(indexName);
            IndexMetadata.State indexState = indexMetadata.getState();
            IndexStats indexStats = (IndexStats)indicesStats.get(indexName);
            boolean searchThrottled = (Boolean)IndexSettings.INDEX_SEARCH_THROTTLED.get(settings);
            ClusterIndexHealth indexHealth = (ClusterIndexHealth)indicesHealths.get(indexName);
            String health = indexHealth != null ? indexHealth.getStatus().toString().toLowerCase(Locale.ROOT) : (indexStats != null ? "red*" : "");
            if (healthParam != null) {
                boolean skip;
                ClusterHealthStatus healthStatusFilter = ClusterHealthStatus.fromString((String)healthParam);
                if (indexHealth != null) {
                    skip = indexHealth.getStatus() != healthStatusFilter;
                } else {
                    boolean bl = skip = ClusterHealthStatus.RED != healthStatusFilter;
                }
                if (skip) {
                    return;
                }
            }
            if (indexStats == null || indexState == IndexMetadata.State.CLOSE) {
                primaryStats = new CommonStats();
                totalStats = new CommonStats();
            } else {
                primaryStats = indexStats.getPrimaries();
                totalStats = indexStats.getTotal();
            }
            table.startRow();
            table.addCell((Object)health);
            table.addCell((Object)indexState.toString().toLowerCase(Locale.ROOT));
            table.addCell(indexName);
            table.addCell((Object)indexMetadata.getIndexUUID());
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfShards()));
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfReplicas()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getCount()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getDeleted()));
            table.addCell((Object)indexMetadata.getCreationDate());
            ZonedDateTime creationTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(indexMetadata.getCreationDate()), ZoneOffset.UTC);
            table.addCell((Object)STRICT_DATE_TIME_FORMATTER.format((TemporalAccessor)creationTime));
            table.addCell(totalStats.getStore() == null ? null : totalStats.getStore().size());
            table.addCell(primaryStats.getStore() == null ? null : primaryStats.getStore().size());
            table.addCell(totalStats.getCompletion() == null ? null : totalStats.getCompletion().getSize());
            table.addCell(primaryStats.getCompletion() == null ? null : primaryStats.getCompletion().getSize());
            table.addCell(totalStats.getFieldData() == null ? null : totalStats.getFieldData().getMemorySize());
            table.addCell(primaryStats.getFieldData() == null ? null : primaryStats.getFieldData().getMemorySize());
            table.addCell(totalStats.getFieldData() == null ? null : Long.valueOf(totalStats.getFieldData().getEvictions()));
            table.addCell(primaryStats.getFieldData() == null ? null : Long.valueOf(primaryStats.getFieldData().getEvictions()));
            table.addCell(totalStats.getQueryCache() == null ? null : totalStats.getQueryCache().getMemorySize());
            table.addCell(primaryStats.getQueryCache() == null ? null : primaryStats.getQueryCache().getMemorySize());
            table.addCell(totalStats.getQueryCache() == null ? null : Long.valueOf(totalStats.getQueryCache().getEvictions()));
            table.addCell(primaryStats.getQueryCache() == null ? null : Long.valueOf(primaryStats.getQueryCache().getEvictions()));
            table.addCell(totalStats.getRequestCache() == null ? null : totalStats.getRequestCache().getMemorySize());
            table.addCell(primaryStats.getRequestCache() == null ? null : primaryStats.getRequestCache().getMemorySize());
            table.addCell(totalStats.getRequestCache() == null ? null : Long.valueOf(totalStats.getRequestCache().getEvictions()));
            table.addCell(primaryStats.getRequestCache() == null ? null : Long.valueOf(primaryStats.getRequestCache().getEvictions()));
            table.addCell(totalStats.getRequestCache() == null ? null : Long.valueOf(totalStats.getRequestCache().getHitCount()));
            table.addCell(primaryStats.getRequestCache() == null ? null : Long.valueOf(primaryStats.getRequestCache().getHitCount()));
            table.addCell(totalStats.getRequestCache() == null ? null : Long.valueOf(totalStats.getRequestCache().getMissCount()));
            table.addCell(primaryStats.getRequestCache() == null ? null : Long.valueOf(primaryStats.getRequestCache().getMissCount()));
            table.addCell(totalStats.getFlush() == null ? null : Long.valueOf(totalStats.getFlush().getTotal()));
            table.addCell(primaryStats.getFlush() == null ? null : Long.valueOf(primaryStats.getFlush().getTotal()));
            table.addCell(totalStats.getFlush() == null ? null : totalStats.getFlush().getTotalTime());
            table.addCell(primaryStats.getFlush() == null ? null : primaryStats.getFlush().getTotalTime());
            table.addCell(totalStats.getGet() == null ? null : Long.valueOf(totalStats.getGet().current()));
            table.addCell(primaryStats.getGet() == null ? null : Long.valueOf(primaryStats.getGet().current()));
            table.addCell(totalStats.getGet() == null ? null : totalStats.getGet().getTime());
            table.addCell(primaryStats.getGet() == null ? null : primaryStats.getGet().getTime());
            table.addCell(totalStats.getGet() == null ? null : Long.valueOf(totalStats.getGet().getCount()));
            table.addCell(primaryStats.getGet() == null ? null : Long.valueOf(primaryStats.getGet().getCount()));
            table.addCell(totalStats.getGet() == null ? null : totalStats.getGet().getExistsTime());
            table.addCell(primaryStats.getGet() == null ? null : primaryStats.getGet().getExistsTime());
            table.addCell(totalStats.getGet() == null ? null : Long.valueOf(totalStats.getGet().getExistsCount()));
            table.addCell(primaryStats.getGet() == null ? null : Long.valueOf(primaryStats.getGet().getExistsCount()));
            table.addCell(totalStats.getGet() == null ? null : totalStats.getGet().getMissingTime());
            table.addCell(primaryStats.getGet() == null ? null : primaryStats.getGet().getMissingTime());
            table.addCell(totalStats.getGet() == null ? null : Long.valueOf(totalStats.getGet().getMissingCount()));
            table.addCell(primaryStats.getGet() == null ? null : Long.valueOf(primaryStats.getGet().getMissingCount()));
            table.addCell(totalStats.getIndexing() == null ? null : Long.valueOf(totalStats.getIndexing().getTotal().getDeleteCurrent()));
            table.addCell(primaryStats.getIndexing() == null ? null : Long.valueOf(primaryStats.getIndexing().getTotal().getDeleteCurrent()));
            table.addCell(totalStats.getIndexing() == null ? null : totalStats.getIndexing().getTotal().getDeleteTime());
            table.addCell(primaryStats.getIndexing() == null ? null : primaryStats.getIndexing().getTotal().getDeleteTime());
            table.addCell(totalStats.getIndexing() == null ? null : Long.valueOf(totalStats.getIndexing().getTotal().getDeleteCount()));
            table.addCell(primaryStats.getIndexing() == null ? null : Long.valueOf(primaryStats.getIndexing().getTotal().getDeleteCount()));
            table.addCell(totalStats.getIndexing() == null ? null : Long.valueOf(totalStats.getIndexing().getTotal().getIndexCurrent()));
            table.addCell(primaryStats.getIndexing() == null ? null : Long.valueOf(primaryStats.getIndexing().getTotal().getIndexCurrent()));
            table.addCell(totalStats.getIndexing() == null ? null : totalStats.getIndexing().getTotal().getIndexTime());
            table.addCell(primaryStats.getIndexing() == null ? null : primaryStats.getIndexing().getTotal().getIndexTime());
            table.addCell(totalStats.getIndexing() == null ? null : Long.valueOf(totalStats.getIndexing().getTotal().getIndexCount()));
            table.addCell(primaryStats.getIndexing() == null ? null : Long.valueOf(primaryStats.getIndexing().getTotal().getIndexCount()));
            table.addCell(totalStats.getIndexing() == null ? null : Long.valueOf(totalStats.getIndexing().getTotal().getIndexFailedCount()));
            table.addCell(primaryStats.getIndexing() == null ? null : Long.valueOf(primaryStats.getIndexing().getTotal().getIndexFailedCount()));
            table.addCell(totalStats.getMerge() == null ? null : Long.valueOf(totalStats.getMerge().getCurrent()));
            table.addCell(primaryStats.getMerge() == null ? null : Long.valueOf(primaryStats.getMerge().getCurrent()));
            table.addCell(totalStats.getMerge() == null ? null : Long.valueOf(totalStats.getMerge().getCurrentNumDocs()));
            table.addCell(primaryStats.getMerge() == null ? null : Long.valueOf(primaryStats.getMerge().getCurrentNumDocs()));
            table.addCell(totalStats.getMerge() == null ? null : totalStats.getMerge().getCurrentSize());
            table.addCell(primaryStats.getMerge() == null ? null : primaryStats.getMerge().getCurrentSize());
            table.addCell(totalStats.getMerge() == null ? null : Long.valueOf(totalStats.getMerge().getTotal()));
            table.addCell(primaryStats.getMerge() == null ? null : Long.valueOf(primaryStats.getMerge().getTotal()));
            table.addCell(totalStats.getMerge() == null ? null : Long.valueOf(totalStats.getMerge().getTotalNumDocs()));
            table.addCell(primaryStats.getMerge() == null ? null : Long.valueOf(primaryStats.getMerge().getTotalNumDocs()));
            table.addCell(totalStats.getMerge() == null ? null : totalStats.getMerge().getTotalSize());
            table.addCell(primaryStats.getMerge() == null ? null : primaryStats.getMerge().getTotalSize());
            table.addCell(totalStats.getMerge() == null ? null : totalStats.getMerge().getTotalTime());
            table.addCell(primaryStats.getMerge() == null ? null : primaryStats.getMerge().getTotalTime());
            table.addCell(totalStats.getRefresh() == null ? null : Long.valueOf(totalStats.getRefresh().getTotal()));
            table.addCell(primaryStats.getRefresh() == null ? null : Long.valueOf(primaryStats.getRefresh().getTotal()));
            table.addCell(totalStats.getRefresh() == null ? null : totalStats.getRefresh().getTotalTime());
            table.addCell(primaryStats.getRefresh() == null ? null : primaryStats.getRefresh().getTotalTime());
            table.addCell(totalStats.getRefresh() == null ? null : Long.valueOf(totalStats.getRefresh().getExternalTotal()));
            table.addCell(primaryStats.getRefresh() == null ? null : Long.valueOf(primaryStats.getRefresh().getExternalTotal()));
            table.addCell(totalStats.getRefresh() == null ? null : totalStats.getRefresh().getExternalTotalTime());
            table.addCell(primaryStats.getRefresh() == null ? null : primaryStats.getRefresh().getExternalTotalTime());
            table.addCell(totalStats.getRefresh() == null ? null : Integer.valueOf(totalStats.getRefresh().getListeners()));
            table.addCell(primaryStats.getRefresh() == null ? null : Integer.valueOf(primaryStats.getRefresh().getListeners()));
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getFetchCurrent()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getFetchCurrent()));
            table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getFetchTime());
            table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getFetchTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getFetchCount()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getFetchCount()));
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getOpenContexts()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getOpenContexts()));
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getQueryCurrent()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getQueryCurrent()));
            table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getQueryTime());
            table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getQueryTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getQueryCount()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getQueryCount()));
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
                table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getConcurrentQueryCurrent()));
                table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getConcurrentQueryCurrent()));
                table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getConcurrentQueryTime());
                table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getConcurrentQueryTime());
                table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getConcurrentQueryCount()));
                table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getConcurrentQueryCount()));
                table.addCell(totalStats.getSearch() == null ? null : Double.valueOf(totalStats.getSearch().getTotal().getConcurrentAvgSliceCount()));
                table.addCell(primaryStats.getSearch() == null ? null : Double.valueOf(primaryStats.getSearch().getTotal().getConcurrentAvgSliceCount()));
            }
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getScrollCurrent()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getScrollCurrent()));
            table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getScrollTime());
            table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getScrollTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getScrollCount()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getScrollCount()));
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getPitCurrent()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getPitCurrent()));
            table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getPitTime());
            table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getPitTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getPitCount()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getPitCount()));
            table.addCell(totalStats.getSegments() == null ? null : Long.valueOf(totalStats.getSegments().getCount()));
            table.addCell(primaryStats.getSegments() == null ? null : Long.valueOf(primaryStats.getSegments().getCount()));
            table.addCell(totalStats.getSegments() == null ? null : totalStats.getSegments().getZeroMemory());
            table.addCell(primaryStats.getSegments() == null ? null : primaryStats.getSegments().getZeroMemory());
            table.addCell(totalStats.getSegments() == null ? null : totalStats.getSegments().getIndexWriterMemory());
            table.addCell(primaryStats.getSegments() == null ? null : primaryStats.getSegments().getIndexWriterMemory());
            table.addCell(totalStats.getSegments() == null ? null : totalStats.getSegments().getVersionMapMemory());
            table.addCell(primaryStats.getSegments() == null ? null : primaryStats.getSegments().getVersionMapMemory());
            table.addCell(totalStats.getSegments() == null ? null : totalStats.getSegments().getBitsetMemory());
            table.addCell(primaryStats.getSegments() == null ? null : primaryStats.getSegments().getBitsetMemory());
            table.addCell(totalStats.getWarmer() == null ? null : Long.valueOf(totalStats.getWarmer().current()));
            table.addCell(primaryStats.getWarmer() == null ? null : Long.valueOf(primaryStats.getWarmer().current()));
            table.addCell(totalStats.getWarmer() == null ? null : Long.valueOf(totalStats.getWarmer().total()));
            table.addCell(primaryStats.getWarmer() == null ? null : Long.valueOf(primaryStats.getWarmer().total()));
            table.addCell(totalStats.getWarmer() == null ? null : totalStats.getWarmer().totalTime());
            table.addCell(primaryStats.getWarmer() == null ? null : primaryStats.getWarmer().totalTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getSuggestCurrent()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getSuggestCurrent()));
            table.addCell(totalStats.getSearch() == null ? null : totalStats.getSearch().getTotal().getSuggestTime());
            table.addCell(primaryStats.getSearch() == null ? null : primaryStats.getSearch().getTotal().getSuggestTime());
            table.addCell(totalStats.getSearch() == null ? null : Long.valueOf(totalStats.getSearch().getTotal().getSuggestCount()));
            table.addCell(primaryStats.getSearch() == null ? null : Long.valueOf(primaryStats.getSearch().getTotal().getSuggestCount()));
            table.addCell((Object)totalStats.getTotalMemory());
            table.addCell((Object)primaryStats.getTotalMemory());
            table.addCell((Object)searchThrottled);
            table.endRow();
        });
        return table;
    }

    private static <A extends ActionResponse> A extractResponse(Collection<? extends ActionResponse> responses, Class<A> c) {
        return (A)responses.stream().filter(c::isInstance).findFirst().get();
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("local", "health"));
        responseParams.addAll(AbstractCatAction.RESPONSE_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

