/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.segments.IndexSegments;
import io.skylite.core.action.admin.indices.segments.IndexShardSegments;
import io.skylite.core.action.admin.indices.segments.IndicesSegmentResponse;
import io.skylite.core.action.admin.indices.segments.PitSegmentsAction;
import io.skylite.core.action.admin.indices.segments.PitSegmentsRequest;
import io.skylite.core.action.admin.indices.segments.ShardSegments;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Table;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestPitSegmentsAction
extends AbstractCatAction {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestPitSegmentsAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/pit_segments/_all"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/pit_segments")));
    }

    @Override
    public String getName() {
        return "cat_pit_segments_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        PitSegmentsRequest pitSegmentsRequest;
        String allPitIdsQualifier = "_all";
        if (request.path().contains(allPitIdsQualifier)) {
            pitSegmentsRequest = new PitSegmentsRequest(new String[]{allPitIdsQualifier});
        } else {
            pitSegmentsRequest = new PitSegmentsRequest();
            try {
                request.withContentOrSourceParamParserOrNull(xContentParser -> {
                    if (xContentParser != null) {
                        pitSegmentsRequest.fromXContent(xContentParser);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse request body", e);
            }
        }
        return channel -> client.execute((ActionType)PitSegmentsAction.INSTANCE, (ActionRequest)pitSegmentsRequest, (ActionListener)new RestResponseListener<IndicesSegmentResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesSegmentResponse indicesSegmentResponse) throws Exception {
                Map indicesSegments = indicesSegmentResponse.getIndices();
                Table tab = RestPitSegmentsAction.this.buildTable(request, indicesSegments);
                return RestTable.buildResponse(tab, this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/pit_segments\n");
        sb.append("/_cat/pit_segments/{pit_id}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"index", "default:true;alias:i,idx;desc:index name");
        table.addCell((Object)"shard", "default:true;alias:s,sh;desc:shard name");
        table.addCell((Object)"prirep", "alias:p,pr,primaryOrReplica;default:true;desc:primary or replica");
        table.addCell((Object)"ip", "default:true;desc:ip of node where it lives");
        table.addCell((Object)"id", "default:false;desc:unique id of node where it lives");
        table.addCell((Object)"segment", "default:true;alias:seg;desc:segment name");
        table.addCell((Object)"generation", "default:true;alias:g,gen;text-align:right;desc:segment generation");
        table.addCell((Object)"docs.count", "default:true;alias:dc,docsCount;text-align:right;desc:number of docs in segment");
        table.addCell((Object)"docs.deleted", "default:true;alias:dd,docsDeleted;text-align:right;desc:number of deleted docs in segment");
        table.addCell((Object)"size", "default:true;alias:si;text-align:right;desc:segment size in bytes");
        table.addCell((Object)"size.memory", "default:true;alias:sm,sizeMemory;text-align:right;desc:segment memory in bytes");
        table.addCell((Object)"committed", "default:true;alias:ic,isCommitted;desc:is segment committed");
        table.addCell((Object)"searchable", "default:true;alias:is,isSearchable;desc:is segment searched");
        table.addCell((Object)"version", "default:true;alias:v,ver;desc:version");
        table.addCell((Object)"compound", "default:true;alias:ico,isCompound;desc:is segment compound");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, Map<String, IndexSegments> indicesSegments) {
        Table table = this.getTableWithHeader(request);
        DiscoveryNodes nodes = this.nodesInCluster.get();
        for (IndexSegments indexSegments : indicesSegments.values()) {
            Map shards = indexSegments.getShards();
            for (IndexShardSegments indexShardSegments : shards.values()) {
                ShardSegments[] shardSegments;
                for (ShardSegments shardSegment : shardSegments = indexShardSegments.getShards()) {
                    List segments = shardSegment.getSegments();
                    for (Segment segment : segments) {
                        table.startRow();
                        table.addCell((Object)shardSegment.getShardRouting().getIndexName());
                        table.addCell((Object)shardSegment.getShardRouting().getId());
                        table.addCell((Object)(shardSegment.getShardRouting().primary() ? "p" : "r"));
                        table.addCell((Object)nodes.get(shardSegment.getShardRouting().currentNodeId()).getHostAddress());
                        table.addCell((Object)shardSegment.getShardRouting().currentNodeId());
                        table.addCell((Object)segment.getName());
                        table.addCell((Object)segment.getGeneration());
                        table.addCell((Object)segment.getNumDocs());
                        table.addCell((Object)segment.getDeletedDocs());
                        table.addCell((Object)segment.getSize());
                        table.addCell((Object)0L);
                        table.addCell((Object)segment.isCommitted());
                        table.addCell((Object)segment.isSearch());
                        table.addCell((Object)segment.getVersion());
                        table.addCell((Object)segment.isCompound());
                        table.endRow();
                    }
                }
            }
        }
        return table;
    }
}

