/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoResponse;
import io.skylite.core.action.admin.cluster.node.info.PluginsAndModules;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.plugins.PluginInfo;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestPluginsAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPluginsAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/plugins"));
    }

    @Override
    public String getName() {
        return "cat_plugins_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/plugins\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestPluginsAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) throws Exception {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
                nodesInfoRequest.timeout(request.param("timeout"));
                nodesInfoRequest.clear().addMetric(NodesInfoRequest.Metric.PLUGINS.metricName());
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener)new RestResponseListener<NodesInfoResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesInfoResponse nodesInfoResponse) throws Exception {
                        return RestTable.buildResponse(RestPluginsAction.this.buildTable(request, clusterStateResponse, nodesInfoResponse), this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", "default:false;desc:unique node id");
        table.addCell((Object)"name", "alias:n;desc:node name");
        table.addCell((Object)"component", "alias:c;desc:component");
        table.addCell((Object)"version", "alias:v;desc:component version");
        table.addCell((Object)"description", "alias:d;default:false;desc:plugin details");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo) {
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            PluginsAndModules plugins;
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            if (info == null || (plugins = (PluginsAndModules)info.getInfo(PluginsAndModules.class)) == null) continue;
            for (PluginInfo pluginInfo : plugins.getPluginInfos()) {
                table.startRow();
                table.addCell((Object)node.getId());
                table.addCell((Object)node.getName());
                table.addCell((Object)pluginInfo.getName());
                table.addCell((Object)pluginInfo.getVersion());
                table.addCell((Object)pluginInfo.getDescription());
                table.endRow();
            }
            for (PluginInfo moduleInfo : plugins.getModuleInfos()) {
                table.startRow();
                table.addCell((Object)node.getId());
                table.addCell((Object)node.getName());
                table.addCell((Object)(moduleInfo.getName() + " [module]"));
                table.addCell((Object)moduleInfo.getVersion());
                table.addCell((Object)moduleInfo.getDescription());
                table.endRow();
            }
        }
        return table;
    }
}

