/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.segments.IndexSegments;
import io.skylite.core.action.admin.indices.segments.IndexShardSegments;
import io.skylite.core.action.admin.indices.segments.IndicesSegmentResponse;
import io.skylite.core.action.admin.indices.segments.IndicesSegmentsRequest;
import io.skylite.core.action.admin.indices.segments.ShardSegments;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestSegmentsAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestSegmentsAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/segments"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/segments/{index}")));
    }

    @Override
    public String getName() {
        return "cat_segments_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestSegmentsAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        clusterStateRequest.clear().nodes(true).routingTable(true).indices(indices);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                IndicesSegmentsRequest indicesSegmentsRequest = new IndicesSegmentsRequest();
                indicesSegmentsRequest.indices(indices);
                client.admin().indices().segments(indicesSegmentsRequest, (ActionListener)new RestResponseListener<IndicesSegmentResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(IndicesSegmentResponse indicesSegmentResponse) throws Exception {
                        Map indicesSegments = indicesSegmentResponse.getIndices();
                        Table tab = RestSegmentsAction.this.buildTable(request, clusterStateResponse, indicesSegments);
                        return RestTable.buildResponse(tab, this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/segments\n");
        sb.append("/_cat/segments/{index}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"index", "default:true;alias:i,idx;desc:index name");
        table.addCell((Object)"shard", "default:true;alias:s,sh;desc:shard name");
        table.addCell((Object)"prirep", "alias:p,pr,primaryOrReplica;default:true;desc:primary or replica");
        table.addCell((Object)"ip", "default:true;desc:ip of node where it lives");
        table.addCell((Object)"id", "default:false;desc:unique id of node where it lives");
        table.addCell((Object)"segment", "default:true;alias:seg;desc:segment name");
        table.addCell((Object)"generation", "default:true;alias:g,gen;text-align:right;desc:segment generation");
        table.addCell((Object)"docs.count", "default:true;alias:dc,docsCount;text-align:right;desc:number of docs in segment");
        table.addCell((Object)"docs.deleted", "default:true;alias:dd,docsDeleted;text-align:right;desc:number of deleted docs in segment");
        table.addCell((Object)"size", "default:true;alias:si;text-align:right;desc:segment size in bytes");
        table.addCell((Object)"size.memory", "default:true;alias:sm,sizeMemory;text-align:right;desc:segment memory in bytes");
        table.addCell((Object)"committed", "default:true;alias:ic,isCommitted;desc:is segment committed");
        table.addCell((Object)"searchable", "default:true;alias:is,isSearchable;desc:is segment searched");
        table.addCell((Object)"version", "default:true;alias:v,ver;desc:version");
        table.addCell((Object)"compound", "default:true;alias:ico,isCompound;desc:is segment compound");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state, Map<String, IndexSegments> indicesSegments) {
        Table table = this.getTableWithHeader(request);
        DiscoveryNodes nodes = state.getState().nodes();
        for (IndexSegments indexSegments : indicesSegments.values()) {
            Map shards = indexSegments.getShards();
            for (IndexShardSegments indexShardSegments : shards.values()) {
                ShardSegments[] shardSegments;
                for (ShardSegments shardSegment : shardSegments = indexShardSegments.getShards()) {
                    List segments = shardSegment.getSegments();
                    for (Segment segment : segments) {
                        table.startRow();
                        table.addCell((Object)shardSegment.getShardRouting().getIndexName());
                        table.addCell((Object)shardSegment.getShardRouting().getId());
                        table.addCell((Object)(shardSegment.getShardRouting().primary() ? "p" : "r"));
                        table.addCell((Object)nodes.get(shardSegment.getShardRouting().currentNodeId()).getHostAddress());
                        table.addCell((Object)shardSegment.getShardRouting().currentNodeId());
                        table.addCell((Object)segment.getName());
                        table.addCell((Object)segment.getGeneration());
                        table.addCell((Object)segment.getNumDocs());
                        table.addCell((Object)segment.getDeletedDocs());
                        table.addCell((Object)segment.getSize());
                        table.addCell((Object)0L);
                        table.addCell((Object)segment.isCommitted());
                        table.addCell((Object)segment.isSearch());
                        table.addCell((Object)segment.getVersion());
                        table.addCell((Object)segment.isCompound());
                        table.endRow();
                    }
                }
            }
        }
        return table;
    }
}

